import { Button, Select } from 'antd';
import React, { useRef, useEffect, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { Link } from 'umi';
import styles from './index.less';
import { query, supplier, downDetail } from './services';

const { Option } = Select;

const TableList = () => {
  const [supplierList, setSupplierList] = useState([]);
  const [shopId, setShopId] = useState(null);
  const actionRef = useRef();

  useEffect(() => {
    async function fetchData() {
      const data = await supplier();
      setSupplierList(data);
    }
    fetchData();
  }, []);
  const changeSupplier = res => {
    setShopId(res);
  };
  const reload = type => {
    if (type) {
      setShopId(null);
    }
    actionRef.current.reload();
  };

  const down = ({ batchNo }) => {
    downDetail({ batchNo });
  };

  const columns = [
    {
      title: $t('reconciliation.batch'),
      dataIndex: 'batchNo',
      key: 'batchNo',
      hideInSearch: true,
    },
    {
      title: $t('transaction.date'),
      dataIndex: 'tradeDate',
      key: 'tradeDate',
      hideInSearch: true,
    },
    {
      title: $t('transaction.date'),
      dataIndex: 'dateRange',
      key: 'dateRange',
      valueType: 'dateRange',
      hideInTable: true,
    },
    {
      title: $t('supplier.name'),
      dataIndex: 'shopId',
      key: 'shopId',
      hideInTable: true,
      valueType: 'select',
      renderFormItem: () => (
        <Select onChange={changeSupplier} value={shopId} allowClear>
          {supplierList.map(item => (
            <Option value={item.id} key={item.id}>
              {item.name}
            </Option>
          ))}
        </Select>
      ),
    },
    {
      title: $t('supplier.name'),
      dataIndex: 'supplierName',
      key: 'supplierName',
      hideInSearch: true,
    },
    {
      title: $t('our.reconciled.count'),
      dataIndex: 'ownCount',
      key: 'ownCount',
      hideInSearch: true,
    },
    {
      title: $t('thirdparty.reconciliation.count'),
      dataIndex: 'thirdCount',
      key: 'thirdCount',
      hideInSearch: true,
    },
    {
      title: $t('reconciled.count'),
      dataIndex: 'succCount',
      key: 'succCount',
      hideInSearch: true,
    },
    {
      title: $t('reconciliation.status'),
      dataIndex: 'status',
      key: 'status',
      valueEnum: {
        1: $t('average'),
        2: $t('mismatched'),
      },
    },
    {
      title: $t('actions'),
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 120,
      render: (_, row) => [
        <Link
          to={{
            pathname: '/reconciliation/detail',
            query: {
              batchNo: row.batchNo,
            },
          }}
        >
          <Button key="edit" type="primary">{$t('view.details')}</Button>
        </Link>,
      ],
    },
    {
      title: $t('download'),
      dataIndex: 'townName',
      key: 'townName',
      width: 100,
      hideInSearch: true,
      render: (_, row) => [
        <Button
          key="edit"
          type="primary"
          onClick={() => {
            down(row);
          }}
        >{$t('download')}</Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={styles.protable}
        actionRef={actionRef}
        columns={columns}
        params={{ shopId }}
        request={res => query(res)}
        rowKey={r => r.batchNo}
        bordered
        scroll={{ x: 1500 }}
        search={{
          collapsed: false,
        }}
        onReset={() => reload('reset')}
      />
    </PageHeaderWrapper>
  );
};

export default TableList;
