import React, { useState } from 'react';
import { BetaSchemaForm } from '@ant-design/pro-components';
import { notification, Button } from 'antd';
import { infoColumn } from './staticData.js';
import { layout } from '@/utils/bll';
import { apiChangeReceiverMobile } from '../../service';
import ChangeLog from './changeLog.jsx';

/**
 * 更新收货人手机组件
 */
const LogisticsPhone = props => {
  const [visibleLog, setVisibleLog] = useState(false);
  const refForm = React.useRef();
  const { record } = props;
  const closeModal = v => {
    refForm?.current?.resetFields?.();
    !v && props.onClose(false);
  };
  const submitForm = async values => {
    const res = await apiChangeReceiverMobile(values);
    if (res?.success) {
      notification.success({
        message: $t('submitted.successfully'),
      });
      props.onClose(true);
    }
  };

  const getInfo = () =>
    new Promise(resolve => {
      resolve({
        ...record,
      });
    });

  const onShowLog = () => {
    setVisibleLog(true);
  };

  return (
    props.visible && (
      <>
        <BetaSchemaForm
          layoutType="ModalForm"
          title={$t('update.recipient.phone')}
          open={props.visible}
          width="600px"
          modalProps={{
            maskClosable: true,
            destroyOnClose: true,
          }}
          request={getInfo}
          formRef={refForm}
          onOpenChange={closeModal}
          layout="horizontal"
          {...layout}
          onFinish={submitForm}
          columns={infoColumn}
          submitter={{
            render: (p, doms) => [
              <Button htmlType="button" onClick={onShowLog} key="edit">{$t('change.history')}</Button>,
              ...doms,
            ],
          }}
        />
        <ChangeLog
          visible={visibleLog}
          orderNo={record.orderNo}
          onClose={() => setVisibleLog(false)}
        />
      </>
    )
  );
};

export default LogisticsPhone;
