import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { notification, Button, Modal, Image, message } from 'antd';
import { query } from './services';
import style from './style.less';

const ContractView = () => {
  const [visible, setVisible] = useState(false);
  const [url, setUrl] = useState();
  // 查看
  const onLook = ({ contractPdfUrl }) => {
    if (contractPdfUrl) {
      setUrl(contractPdfUrl);
      setVisible(true);
    } else {
      message.error($t('no.contracts'));
    }
  };
  // 下载
  const ondown = ({ contractPdfUrl }) => {
    if (contractPdfUrl) {
      window.open(contractPdfUrl);
    } else {
      message.error($t('no.contracts'));
    }
  };
  const columns = [
    {
      title: $t('contract.name'),
      dataIndex: 'contractName',
      key: 'contractName',
      align: 'center',
    },
    {
      title: $t('signing.time'),
      dataIndex: 'signDate',
      key: 'signDate',
      align: 'center',
      hideInSearch: true,
      render: (val, data) => {
        if (data.signDate && typeof data.signDate === 'string') {
          return data.signDate;
        }
        if (data.signDate && data?.signDate.length) {
          let date = '';
          data.signDate.forEach((item, index) => {
            if (item && item.toString().length === 1) {
              item = `0${item}`;
            }
            if ([0, 1].includes(index)) {
              date += `${item}-`;
            } else if ([3, 4].includes(index)) {
              date += `${item}:`;
            } else {
              date += `${item} `;
            }
          });
          return date;
        }
        return '-';
      },
    },
    {
      title: $t('contract.status'),
      dataIndex: 'state',
      key: 'state',
      align: 'center',
      filters: false,
      valueEnum: {
        0: $t('expired'),
        1: $t('valid'),
      },
    },
    {
      title: $t('actions'),
      dataIndex: 'action',
      width: 200,
      align: 'center',
      hideInSearch: true,
      render: (text, record) => (
        <>
          <Button
            key="edit"
            type="primary"
            onClick={() => onLook(record)}
            style={{ marginRight: '10px' }}
          >{$t('view')}</Button>
          <Button key="del" type="primary" onClick={() => ondown(record)}>{$t('download')}</Button>
        </>
      ),
    },
  ];
  return (
    <PageHeaderWrapper>
      {!visible && (
        <ProTable
          search={{
            collapsed: false,
            collapseRender: () => null,
          }}
          columns={columns}
          request={params => query({ ...params })}
          rowKey={r => r.appealNo}
          expandIconColumnIndex={10}
          bordered
          toolBarRender={false}
          scroll={{ x: '100%', y: 400 }}
          pagination={false}
        />
      )}
      {visible && (
        <div className={style.contract}>
          <iframe src={url} height="600" width="100%" title={$t('contract')}></iframe>
          <Button type="primary" onClick={() => setVisible(false)}>{$t('cancel')}</Button>
        </div>
      )}
    </PageHeaderWrapper>
  );
};
export default ContractView;
