import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Cascader, notification } from 'antd';
import { shopAudit } from '../service';

const FormItem = Form.Item;
const { TextArea } = Input;
const AuditModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    formData = {},
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const treeData = [
    {
      label: $t('agree'),
      value: true,
    },
    {
      label: $t('disagree'),
      value: false,
      children: [
        {
          label: $t('order.shipped'),
          value: 10,
        },
        {
          label: $t('confirmed.delivery.with.client'),
          value: 20,
        },
        {
          label: $t('other'),
          value: 30,
        },
      ],
    },
  ];
  const handleOk = () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const { approve } = fieldsValue;
        const data = await shopAudit({
          ...fieldsValue,
          refuseReasonCode: approve?.[1],
          approve: approve?.[0],
          serviceNo: formData?.serviceNo,
        });
        if (data.businessCode === '0000') {
          notification.success({ message: approve?.[0] ? $t('review.success') : $t('rejection.submitted') });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  const approve = getFieldValue('approve');
  const isRefuse = () => approve && approve[0] !== 1;
  return (
    <Modal
      title={$t('aftersales.confirmation')}
      visible={visible}
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label={$t('review.result')}>
          {getFieldDecorator('approve')(
            <Cascader
              allowClear
              showSearch
              style={{ width: '315px' }}
              dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
              options={treeData}
              placeholder={$t('select')}
            />,
          )}
        </FormItem>
        {isRefuse() && approve[1] === 30 && (
          <FormItem label={$t('rejection.reason')}>
            {getFieldDecorator('refuseReasonRemark', {
              initialValue: formData.refuseDesc,
              rules: [
                {
                  required: true,
                  message: $t('enter.rejection.reason'),
                },
              ],
            })(
              <TextArea
                placeholder={$t('enter.rejection.reason')}
                allowClear
                autoSize={{ minRows: 3, maxRows: 6 }}
              />,
            )}
          </FormItem>
        )}
      </Form>
    </Modal>
  );
};

export default Form.create()(AuditModal);
