import React, { useState, useEffect } from 'react';
import { Checkbox, Space, Modal, notification, message } from 'antd';
import { mealColumn } from '../staticData/goods';
import { apiMealInfoUpdate, apiEnterpriseInfo, apiCheckInfo } from '../service';

const SaleDateModal = props => {
  const [value, setValue] = useState([]);
  const [loading, setLoading] = useState(false);
  const [tabCateList, setTabCateList] = useState(Object.keys(mealColumn));

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeMeal = e => {
    setValue(e);
  };

  // 提交
  const handleConfirm = async () => {
    if (!value || value.length < 1) {
      message.error($t('select.meal.period'));
      return;
    }
    const arr = value.sort((x, y) => x - y);
    if (props.productType === 4) {
      const data = [];
      props.dataSource.forEach(item => {
        const obj = {
          saleDateList: item.saleDate,
          tabCateList: item.tabCate?.map(v => ({ tabId: v })),
        };
        if (props.item.skuId === item.skuId && item.saleDate) {
          obj.tabCateList = arr.map(v => ({ tabId: v }));
          data.push(obj);
        } else if (item.saleDate?.length && item.tabCate?.length) {
          data.push(obj);
        }
      });
      const res = await apiCheckInfo(data);
      if (!res || !res.success) {
        return;
      }
    }
    if (props.id) {
      const params = {
        id: props.id,
        tabIds: arr,
      };
      await apiMealInfoUpdate(params);
      notification.success({ message: $t('saved.successfully') });
    }
    handleCancel();
    props.handleRefresh(arr);
  };

  // 获取店铺餐段通过企业ID
  const getEnterpriseMealColumn = async valueList => {
    setLoading(true);
    const res = await apiEnterpriseInfo(props.enterpriseID);
    setLoading(false);
    if (res && res.data && res.data.mealTimePeriod && res.data.mealTimePeriod.length) {
      const arr = res.data.mealTimePeriod.map(item => `${item.mealPeriodType}`);
      setTabCateList(arr);
      // 餐段的值需在企业配置的可选餐段之内
      const v = [];
      valueList.forEach(t => {
        arr.includes(t) && v.push(t);
      });
      setValue(v);
    }
  };

  useEffect(() => {
    if (props.visible) {
      let v = [];
      let tabCate = [];
      if (props.item) {
        if (props.type) {
          tabCate = props.item[props.type];
        }
        tabCate = tabCate || props.item.tabCateList || props.item.tabCate;
      }
      if (tabCate && tabCate.length) {
        v = tabCate.map(item => {
          if (typeof item === 'object') {
            return `${item.tabId}`;
          }
          return `${item}`;
        });
      }
      setValue(v);
      if (props.enterpriseID) {
        getEnterpriseMealColumn(v);
      }
    }
  }, [props.visible]);

  return (
    <Modal
      title={props.title || $t('set.sale.periods')}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="200px"
      okText={$t('save')}
      confirmLoading={loading}
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Checkbox.Group onChange={onChangeMeal} value={value}>
        <Space direction="vertical">
          {tabCateList.map(key => (
            <Checkbox key={key} value={key}>
              {mealColumn[key]}
            </Checkbox>
          ))}
        </Space>
      </Checkbox.Group>
    </Modal>
  );
};
export default SaleDateModal;
