import React, { useEffect } from 'react';
import { Form, InputNumber, Modal, notification } from 'antd';
import { apiMealInfoUpdate } from '../service';

const SaleDateModal = props => {
  const [form] = Form.useForm();

  const layout = {
    labelCol: { span: 8 },
    wrapperCol: { span: 14 },
  };

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    const params = {
      id: props.id,
      sort: res.sort,
    };
    await apiMealInfoUpdate(params);
    notification.success({ message: $t('saved.successfully') });
    handleCancel();
    props.handleRefresh();
  };

  useEffect(() => {
    if (props.visible) {
      const sort = props.item?.sort || 1000;
      form.setFieldsValue({ sort });
    }
  }, [props.visible]);

  return (
    <Modal
      title={$t('edit.product.sorting')}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="300px"
      okText={$t('save')}
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basicInfo" {...layout} form={form}>
        <Form.Item label={$t('sort')} name="sort" rules={[{ required: true, message: $t('enter.sort.order') }]}>
          <InputNumber max={999999} min={0} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SaleDateModal;
