import React from 'react';
import { Modal, Form, Select } from 'antd';

const SwitchGroupModal = options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);

    options.confirm({
      type: 3,
      ...values,
    });
  };

  const radioOptions = [{ label: $t('yes'), value: 1 }, { label: $t('no'), value: 0 }];
  const initialValues = Object.assign({}, options.initialValues);

  return (
    <Modal
      visible={options.visible}
      title={$t('change.group')}
      onOk={handleOk}
      maskClosable={false}
      keyboard={false}
      confirmLoading={options.loading}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label={$t('group')}
          name="storageRackId"
          rules={[{ required: true, message: $t('selection.required') }]}
        >
          <Select options={radioOptions} />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default SwitchGroupModal;
