import React, { useRef, useEffect } from 'react';
import { Modal, Form, Upload, Input } from 'antd';
import { apiMerchantView } from '../service';
import { getFileData } from '@/utils/bll';

const formItemLayout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 19 },
};

/**
 * 查看发票
 * */
const InvoiceListModal = props => {
  const refForm = useRef();
  const { id } = props;

  const getDetail = async () => {
    const res = await apiMerchantView(id);
    if (res && res.data) {
      const { invoiceFiles = [], refuseReason } = res.data;
      // 发票列表
      const invoiceList = [];
      // 补录发票列表
      const subInvoiceList = [];

      invoiceFiles.forEach(item => {
        if (item.supplementary) {
          subInvoiceList.push(item);
        } else {
          invoiceList.push(item);
        }
      });

      const params = {
        fileList: getFileData(invoiceList, 'filePath', 'fileName'),
        other: refuseReason,
        sFileList: getFileData(subInvoiceList, 'filePath', 'fileName'),
        sOther: '',
      };
      refForm.current?.setFieldsValue?.(params);
    }
  };

  useEffect(() => {
    getDetail();
  }, []);

  return (
    <Modal width={800} title={$t('view.invoice')} open footer={null} onCancel={() => props.onCancel(false)}>
      <Form ref={refForm} {...formItemLayout}>
        <Form.Item label={$t('invoice')} name="fileList" valuePropName="fileList">
          <Upload disabled listType="picture-card" />
        </Form.Item>
        <Form.Item label={$t('invoice.remarks')} name="other">
          <Input disabled />
        </Form.Item>
        <Form.Item label={$t('supplement.invoice')} name="sFileList" valuePropName="fileList">
          <Upload disabled listType="picture-card" />
        </Form.Item>
        <Form.Item label={$t('invoice.remarks')} name="sOther">
          <Input disabled />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default InvoiceListModal;
