import React, { Component } from 'react';
import { Modal, Input, Button, Icon, notification } from 'antd';
import { Form } from '@ant-design/compatible';
import styles from '../style.less';
import { renderModal, detailsModal, formItemLayout } from './data';
import Upload from './upload';
import { uploadBill } from '../service';

const { Item: FormItem } = Form;

class toExamine extends Component {
  uploadRef = React.createRef();

  handleCancel = () => {
    const { resetFields, getFieldValue } = this.props.form;
    const { clearFileList } = this.uploadRef.current;
    clearFileList();
    resetFields();
    this.props.close();
  };

  normFile = fileList => fileList;

  handleSubmit = async () => {
    const {
      form: { validateFields },
      toExamineData: { id },
    } = this.props;
    validateFields(async (err, values) => {
      if (err) {
        return;
      }
      if (!values?.fileList[0]?.url) {
        notification.error({ message: $t('invoice.upload.error') });
        return;
      }
      const params = {
        filePath: values?.fileList[0].url,
        fileName: values?.fileList[0]?.name || '',
        id,
      };
      const data = await uploadBill(params);
      if (data.businessCode === '0000') {
        this.handleCancel();
        notification.success({ message: $t('upload.successful') });
      }
    });
  };

  render() {
    const {
      form: { getFieldDecorator },
      visible,
      status,
      toExamineData: { filePath, fileName, refuseReason },
    } = this.props;
    const listFile = [{ url: filePath, name: fileName }];
    return (
      <Modal
        width={400}
        title={status === 1 ? $t('upload.invoice') : $t('view.invoice')}
        open={visible}
        onCancel={() => this.handleCancel()}
        footer={status === 1 ? renderModal.call(this) : detailsModal.call(this, filePath)}
        className={styles.textArea}
      >
        <Form className="login-form" {...formItemLayout}>
          <FormItem label={$t('upload.invoice')}>
            {getFieldDecorator('fileList', {
              rules: [{ required: true, message: $t('upload.invoice') }],
              valuePropName: 'fileList',
              getValueFromEvent: this.normFile,
              initialValue: status === 1 ? [] : listFile,
            })(<Upload max={1} ref={this.uploadRef} status={status} />)}
          </FormItem>
          {status === 2 ? (
            <FormItem label={$t('remark')}>
              {getFieldDecorator('remark', {
                initialValue: refuseReason,
              })(<Input.TextArea rows={5} disabled />)}
            </FormItem>
          ) : (
            <div className="tipMessage">{$t('formats.pdfdocdocxpngjpegziprar')}</div>
          )}
        </Form>
      </Modal>
    );
  }
}
export default Form.create()(toExamine);
