import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Select, Cascader, Tag, notification } from 'antd';
import { da } from 'date-fns/locale';
import React, { useState, useEffect } from 'react';
import { getTemplate, getAfterAddress } from '../service';

const { Option } = Select;

const TempleatModal = props => {
  const {
    visible,
    form: { getFieldDecorator, validateFields, resetFields },
    selectedRowKeys,
    templateList,
    isALL,
    isType,
    total,
  } = props;
  const formItemLayout = {
    labelCol: {
      span: 6,
    },
    wrapperCol: {
      span: 16,
    },
  };
  const setAfterAddress = async fieldsValue => {
    const data = await getAfterAddress({
      skuIds: selectedRowKeys || [],
      afterAddressId: fieldsValue.templateId.key,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: $t('config.success') });
      resetFields();
      props.onCancel();
    }
  };
  const setTemplate = async fieldsValue => {
    const data = await getTemplate({
      isAll: isALL,
      skuIdList: selectedRowKeys,
      templateId: fieldsValue.templateId.key,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: $t('config.success') });
      resetFields();
      props.onCancel();
    }
  };
  const handleOk = async () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        if (isType === 'after') {
          setAfterAddress(fieldsValue);
        }
        if (isType === 'distribution') {
          setTemplate(fieldsValue);
        }
      }
    });
  };

  const title = () => {
    if (isType === 'distribution') {
      if (isALL) {
        return $t('global.shipping.zones');
      }
      return $t('selected.shipping.zones');
    }
    if (isType === 'after') {
      if (isALL) {
        return $t('global.aftersales.address');
      }
      return $t('selected.product.address');
    }
    return '';
  };

  return (
    <Modal
      title={title()}
      visible={visible}
      width="500px"
      onCancel={props.onCancel}
      onOk={() => handleOk()}
    >
      {!isALL && <p>{$t('selected')}{selectedRowKeys.length}{$t('products')}</p>}
      {isALL > 0 && isType === 'after' && <p>{$t('selected')}{total}{$t('products')}</p>}
      <Form {...formItemLayout}>
        <Form.Item label={isType === 'after' ? $t('select.aftersales.address') : $t('select.template')}>
          {getFieldDecorator('templateId', {
            rules: [
              {
                required: true,
                message: `${isType === 'after' ? '请选择售后地址' : '请选择模板'}`,
              },
            ],
          })(
            <Select
              placeholder={isType === 'after' ? $t('select.aftersales.address') : $t('select.template')}
              labelInValue
              allowClear
            >
              {isType === 'distribution' &&
                templateList.map(item => (
                  <Option label={item.templateName} value={item.id} key={item.id}>
                    {item.templateName}
                  </Option>
                ))}
              {isType === 'after' &&
                templateList.map(item => (
                  <Option label={item.addressName} value={item.id} key={item.id}>
                    {item.addressName}
                  </Option>
                ))}
            </Select>,
          )}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(TempleatModal);
