import React from 'react';
import { Image as ImageComponent, Button, Switch } from 'antd';
import { FormOutlined } from '@ant-design/icons';

export const repastTypeList = [
  {
    value: 0,
    label: $t('block'),
  },
  {
    value: 1,
    label: $t('normal'),
  },
];

export const columns = props => [
  {
    title: $t('department.name'),
    key: 'departmentName',
    dataIndex: 'departmentName',
    align: 'center',
  },
  {
    title: $t('employee.name'),
    key: 'staffName',
    dataIndex: 'staffName',
    align: 'center',
  },
  {
    title: $t('employee.id'),
    key: 'staffNo',
    dataIndex: 'staffNo',
    align: 'center',
  },
  {
    title: $t('employee.mobile'),
    key: 'mobile',
    dataIndex: 'mobile',
    align: 'center',
  },
  {
    title: $t('employee.status'),
    key: 'isBlack',
    dataIndex: 'isBlack',
    align: 'center',
    render: _ => (_ ? $t('block') : $t('normal')),
  },
  {
    title: $t('balancevoucher.status'),
    key: 'balanceBackFlag',
    dataIndex: 'balanceBackFlag',
    align: 'center',
    render: _ => (_ ? $t('recalled') : $t('normal')),
  },
  {
    title: $t('spending.limit'),
    key: 'isLimit',
    dataIndex: 'isLimit',
    align: 'center',
    width: '150px',
    render: (_, row) => (
      <>
        <Switch defaultChecked={row?.isLimit} onChange={val => props.handleLimitChange(val, row)} />
        &nbsp;<span>{row?.isLimit ? $t('enabled') : $t('closed')}</span>
      </>
    ),
  },
  {
    title: $t('employee.enterprise.balance'),
    key: 'balance',
    dataIndex: 'balance',
    align: 'center',
  },
  {
    title: $t('valid.meal.coupons'),
    key: 'couponCount',
    dataIndex: 'couponCount',
    align: 'center',
  },
  {
    title: $t('actions'),
    dataIndex: 'option',
    valueType: 'option',
    align: 'center',
    key: 'option',
    render: (_, row) => [
      <Button type="link" key="goDetails" onClick={() => props.goDetails(row)}>{$t('balance.topup.details')}</Button>,
      <Button
        type="link"
        key="delEmployee"
        disabled={!row?.isBlack}
        onClick={() => props.delEmployee(row)}
      >{$t('delete')}</Button>,
    ],
  },
];
