import React from 'react';
import { Modal, Table } from 'antd';

const RechargeDetailsModal = ({ visible, onClose, list }) => {
  const columns = [
    {
      title: $t('employee.id'),
      dataIndex: 'staffNo',
      key: 'staffNo',
      align: 'center',
    },
    {
      title: $t('employee.name'),
      dataIndex: 'staffName',
      key: 'staffName',
      align: 'center',
    },
    {
      title: $t('top.up.balance'),
      dataIndex: 'rechargeAmount',
      key: 'rechargeAmount',
      align: 'center',
    },
    {
      title: $t('topup.time'),
      dataIndex: 'generateDate',
      key: 'generateDate',
      align: 'center',
    },
  ];

  return (
    <Modal
      width="800px"
      visible={visible}
      title={$t('topup.details')}
      onCancel={() => onClose(false, 'rechargeDetails')}
      footer={null}
    >
      <Table
        dataSource={list}
        columns={columns}
        rowKey={record => record.id}
        pagination={false}
        bordered
      />
    </Modal>
  );
};

export default RechargeDetailsModal;
