import React from 'react';
import moment from 'moment';
import MealSection from './components/MealSection';
import MealFormListLimit from './components/MealFormListLimitForm';
import { getPickSelf } from './bll';

const hideEnums = { hidePrice: $t('hide.product.price'), hideImage: $t('hide.product.image') };
const weekMap = new Map([[1, $t('yes')], [0, $t('no')]]);

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};

// 餐品类型
export const mealType = {
  1: $t('takeaway'),
  2: $t('buffet'),
  4: $t('instore'),
};
// 餐段
export const mealSections = {
  1: $t('breakfast'),
  2: $t('lunch'),
  4: $t('dinner'),
};

// 校验时间
const checkTime = (arr, current) => {
  let valid = false;
  arr.forEach(item => {
    if (current < item.endTime) {
      valid = true;
    }
  });
  return valid;
};
// 验证餐段
const validateMeals = (refForm, selectedMealSections) => {
  const { mealTimePeriod = [] } = refForm.current?.getFieldValue?.() || {};
  const arr = [];
  let validTime = false;
  mealTimePeriod.forEach(item => {
    if (item && selectedMealSections[item.mealPeriodType]) {
      const obj = { ...item };
      if (obj.time?.length === 2) {
        obj.beginTime = moment(obj.time[0]).format('HH:mm');
        obj.endTime = moment(obj.time[1]).format('HH:mm');
        if (checkTime(arr, obj.beginTime, selectedMealSections[item.mealPeriodType])) {
          validTime = true;
        }
        arr.push(obj);
      }
    }
  });
  if (validTime) {
    // eslint-disable-next-line prefer-promise-reject-errors
    return Promise.reject($t('time.slots.cannot.overlap'));
  }
  return Promise.resolve();
};

// 获取 schemaForm 的 columns
export const getBaseFormItem = options => {
  const {
    id,
    selectedMealTypes,
    onChangeMealType,
    selectedMealSections,
    onChangeMealSection,
    refForm,
  } = options;

  const baseColumn = [
    {
      title: $t('enterprise.name'),
      dataIndex: 'name',
      formItemProps: {
        rules: [{ required: true, message: $t('enter.company.name') }],
      },
    },
    {
      hideInForm: !!id,
      title: $t('enterprise.pickup.point'),
      dataIndex: 'pickSelfIds',
      valueType: 'select',
      fieldProps: {
        mode: 'multiple',
      },
      request: getPickSelf,
      formItemProps: {
        rules: [{ required: true, message: $t('select.pickup.point') }],
      },
    },
    {
      title: $t('enterprise.deadline'),
      dataIndex: 'endOrderTime',
      valueType: 'digit',
      formItemProps: {
        rules: [{ required: true, message: $t('enter.deadline') }],
        addonAfter: $t('minutes'),
        extra: <span>{$t('employee.order.cutoff.time.minutes.positive.integers.only')}</span>,
      },
    },
    {
      title: $t('food.type'),
      dataIndex: 'mealType',
      valueType: 'checkbox',
      valueEnum: mealType,
      formItemProps: {
        rules: [{ required: true, message: $t('select.meal.type') }],
      },
      fieldProps: {
        onChange: onChangeMealType,
        name: 'mealType',
      },
    },
    {
      title: $t('meal.period.config'),
      dataIndex: 'mealTimePeriod',
      formItemProps: {
        rules: [{ required: true, message: $t('select.period.config') }],
      },
      fieldProps: {
        copyIconProps: false, // 隐藏复制行按钮
        deleteIconProps: false, // 隐藏删除行按钮
        creatorButtonProps: false, // 隐藏添加行按钮
      },
      renderFormItem: () => (
        <MealSection
          meals={selectedMealSections}
          validateMeals={() => validateMeals(refForm, selectedMealSections)}
          onChangeSection={onChangeMealSection}
        />
      ),
    },
    {
      title: '',
      dataIndex: '',
      valueType: 'divider',
      formItemProps: {
        wrapperCol: { span: 22 },
      },
      fieldProps: {
        children: $t('business.transaction.limit'),
        orientation: 'left',
      },
    },
    {
      title: '',
      dataIndex: 'mealLimit',
      formItemProps: {
        labelCol: { span: 0 },
        wrapperCol: { span: 24 },
      },
      renderFormItem: () => MealFormListLimit(selectedMealSections, selectedMealTypes),
    },
    {
      title: $t('hidden.product.info'),
      dataIndex: 'hideInfo',
      valueType: 'checkbox',
      valueEnum: hideEnums,
    },
    {
      title: $t('weekly.preview'),
      dataIndex: 'weekPreview',
      formItemProps: {
        rules: [{ required: true, message: $t('select.week.preview') }],
      },
      valueType: 'radio',
      valueEnum: weekMap,
      // convertValue: v => `${v}`, // 从接口获取的数据做简单转换
    },
  ];
  return baseColumn;
};
