import { Button, Tag, Popover } from 'antd';
import React from 'react';
import styles from './index.less';

export function columns(res) {
  return [
    {
      title: 'ID',
      dataIndex: 'id',
      key: 'id',
      width: 80,
      align: 'center',
    },
    {
      title: $t('name'),
      dataIndex: 'templateName',
      width: 200,
      key: 'templateName',
      align: 'center',
    },
    {
      title: $t('address'),
      dataIndex: 'areaNameList',
      key: 'areaNameList',
      align: 'center',
      width: 500,
      render: (_, row) => {
        const data = row.areaNameList?.join(',');
        const content = <p className={styles.content}>{data}</p>;
        return (
          <Popover content={content} title={$t('delivery.area.not.supported')} trigger="hover">
            <p className={styles.p}>{data}</p>
          </Popover>
        );
      },
    },
    {
      title: $t('actions'),
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      align: 'center',
      width: 100,
      render: (_, row) => {
        if (!res.canEditable) {
          return '-';
        }
        return (
          <div className={styles.option}>
            <Button type="primary" onClick={() => res.edit(0, row)}>{$t('copy')}</Button>
            <Button type="primary" onClick={() => res.edit(1, row)}>{$t('edit')}</Button>
          </div>
        );
      },
    },
  ];
}
