import slash from 'slash2';
import defaultSettings from './defaultSettings'; // https://umijs.org/config/
import webpackPlugin from './plugin.config';
import groupMealRoute from './groupMealRoute';

const { pwa, primaryColor } = defaultSettings; // preview.pro.ant.design only do not use in your production ;
// preview.pro.ant.design 专用环境变量，请不要在你的项目中使用它。

const { ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION } = process.env;
const isAntDesignProPreview = ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION === 'site';
const plugins = [
  [
    'umi-plugin-react',
    {
      antd: true,
      dva: {
        hmr: true,
      },
      locale: {
        // default false
        enable: true,
        // default zh-CN
        default: 'zh-CN',
        // default true, when it is true, will use `navigator.language` overwrite default
        baseNavigator: true,
      },
      // dynamicImport: {
      //   loadingComponent: './components/PageLoading/index',
      //   webpackChunkName: true,
      //   level: 3,
      // },
      pwa: false,
      // default close dll, because issue https://github.com/ant-design/ant-design-pro/issues/4665
      // dll features https://webpack.js.org/plugins/dll-plugin/
      // dll: {
      //   include: ['dva', 'dva/router', 'dva/saga', 'dva/fetch'],
      //   exclude: ['@babel/runtime', 'netlify-lambda'],
      // },
    },
  ],
  [
    'umi-plugin-pro-block',
    {
      moveMock: false,
      moveService: false,
      modifyRequest: true,
      autoAddMenu: true,
    },
  ],
];
export default {
  antd: {},
  dva: {
    hmr: true,
  },
  devServer: {
    host: '0.0.0.0', // 配置 IP，0.0.0.0 表示监听所有可用的网络接口
    port: 8001, // 配置端口号
  },
  hash: true,
  locale: {
    default: 'zh-CN', //开启国际化配置，就必须要创建locales/zh-CN.ts 文件
    baseNavigator: true,
  },
  targets: {
    ie: 11,
  },
  // devtool: process.env.SENTRY_ENV === 'prod' ? 'hidden-source-map' : false,
  // devtool: 'source-map',
  // uglifyJSOptions: {
  //   sourceMap: true
  // },
  // umi routes: https://umijs.org/zh/guide/router.html
  routes: [
    {
      path: '/user',
      component: '../layouts/UserLayout',
      routes: [
        {
          name: 'login',
          path: '/user/login',
          component: './user/login',
        },
      ],
    },
    {
      path: '/',
      component: '../layouts/SecurityLayout',
      title: $t('merchant.admin'),
      routes: [
        {
          path: '/',
          component: '../layouts/BasicLayout',
          authority: ['Admin', 'user'],
          routes: [
            {
              title: $t('home'),
              path: '/',
              component: './Admin',
            },
            {
              title: $t('merchant.admin'),
              path: '/orderManage/queryOrder',
              name: 'queryOrder',
              component: './orderManage/queryOrder',
            },
            {
              title: $t('merchant.admin'),
              path: '/orderManage/pendingDeliveryOrder',
              name: 'pendingDeliveryOrder',
              component: './orderManage/pendingDeliveryOrder',
            },
            {
              title: $t('merchant.admin'),
              path: '/orderManage/deliveryOrder',
              name: 'deliveryOrder',
              component: './orderManage/deliveryOrder',
            },
            {
              title: $t('merchant.admin'),
              path: '/orderManage/batchDelivery',
              name: 'batchDeliveryOrder',
              component: './orderManage/batchDelivery',
            },
            {
              title: $t('merchant.admin'),
              path: '/afterSaleAddress',
              name: 'afterSaleAddress',
              component: './afterSaleAddress',
            },
            {
              title: $t('merchant.admin'),
              path: '/reconciliation',
              name: 'reconciliation',
              component: './reconciliation',
            },
            {
              title: $t('merchant.admin'),
              path: '/reconciliation/detail',
              name: 'reconciliationDetail',
              component: './reconciliation/detail/index',
            },
            {
              title: $t('merchant.admin'),
              path: '/settleManage',
              name: 'settleManage',
              component: './settleManage',
            },
            {
              title: $t('merchant.admin'),
              path: '/afterSaleManage',
              name: 'afterSaleManage',
              icon: 'smile',
              component: './AfterSaleManage/index',
            },
            {
              title: $t('merchant.admin'),
              path: '/afterSalesClaimForm',
              name: 'afterSalesClaimForm',
              icon: 'smile',
              component: './AfterSalesClaimForm/index',
            },
            {
              title: $t('merchant.admin'),
              path: '/afterSaleManageOld',
              name: 'afterSaleManageOld',
              icon: 'smile',
              component: './AfterSaleManageOld/index',
            },
            {
              title: $t('merchant.admin'),
              path: '/auditPending',
              name: 'auditPending',
              icon: 'smile',
              component: './AfterSaleManageOld/Pending',
            },
            {
              title: $t('merchant.admin'),
              path: '/passAudit',
              name: 'passAudit',
              icon: 'smile',
              component: './AfterSaleManageOld/PassAudit',
            },
            {
              title: $t('merchant.admin'),
              path: '/appeal',
              name: 'appeal',
              component: './afterSale/appeal',
            },
            {
              title: $t('merchant.admin'),
              path: '/cancelBillManage',
              name: 'cancelBillManage',
              component: './cancelBillManage',
            },
            {
              title: $t('merchant.admin'),
              path: '/goodsManage',
              name: 'goodsManage',
              icon: 'smile',
              component: './GoodsManage',
            },
            {
              path: '/distributionArea',
              name: 'distributionArea',
              icon: 'smile',
              component: './distributionArea',
            },
            {
              title: $t('merchant.admin'),
              path: '/reconciliationQuery',
              name: 'reconciliationQuery',
              icon: 'smile',
              component: './ReconciliationQuery',
            },
            {
              title: $t('merchant.admin'),
              path: '/settlementSheet',
              name: 'settlementSheet',
              icon: 'smile',
              component: './SettlementSheet',
            },
            {
              title: $t('merchant.admin'),
              path: '/paymentMange',
              name: 'paymentMange',
              icon: 'smile',
              component: './PaymentMange',
            },
            {
              path: '/password',
              name: 'password',
              icon: 'smile',
              component: './password',
            },
            {
              path: '/chainStoreManage',
              name: 'chainStoreManage',
              icon: 'smile',
              component: './chainStoreManage',
            },
            // {
            //   path: '/GoodsManage-new',
            //   name: 'GoodsManageNew',
            //   component: './GoodsManage-new',
            // },
            {
              title: $t('service.product.revampmodule'),
              path: '/ServiceGoods/:id',
              name: 'ServiceGoods',
              component: './ServiceGoods/index',
            },
            {
              title: $t('merchant.admin.account.management'),
              path: '/systemManage/account',
              name: 'systemManageAccount',
              component: './systemManage/Account',
            },
            {
              title: $t('merchant.admin.user.info'),
              path: '/systemManage/account/userInfo',
              name: 'accountUserInfo',
              component: './systemManage/Account/UserInfo',
            },
            {
              title: $t('merchant.admin.role.management'),
              path: '/systemManage/role',
              name: 'systemManageRole',
              component: './systemManage/Role',
            },
            {
              title: $t('merchant.admin.role.info'),
              path: '/systemManage/role/roleInfo',
              name: 'roleInfo',
              component: './systemManage/Role/RoleInfo',
            },
            {
              title: $t('merchant.admin.logs'),
              path: '/systemManage/log',
              name: 'systemManageLog',
              component: './systemManage/Log',
            },
            {
              title: $t('merchant.admin.contract.view'),
              path: '/contractView',
              name: 'contractView',
              component: './contractView',
            },
            {
              title: $t('merchant.admin.merchant.profile'),
              path: '/businessInfo',
              name: 'businessInfo',
              component: './businessManage/info',
            },
            {
              title: $t('merchant.admin.brand.management'),
              path: '/brandManage',
              name: 'brandManage',
              component: './BrandManage',
            },
            {
              title: $t('merchant.admin.selfoperated.product.price.update'),
              path: '/supplyPriceUpdate',
              name: 'supplyPriceUpdate',
              component: './GoodsManage/SupplyPriceUpdate',
            },
            ...groupMealRoute,
            // ↓↓↓↓↓↓应付审计用的,假的,没有实际用处↓↓↓↓↓↓↓
            {
              title: $t('merchant.admin.pending.shipments'),
              path: '/popOrderManage/popPendingDeliveryOrder',
              name: 'popPendingDeliveryOrder',
              component: './PopOrderManage/pendingDeliveryOrder',
            },
            {
              title: $t('merchant.admin.shipped.orders'),
              path: '/popOrderManage/popDeliveryOrder',
              name: 'popDeliveryOrder',
              component: './PopOrderManage/deliveryOrder',
            },
            {
              title: $t('merchant.admin.batch.shipping'),
              path: '/popOrderManage/popBatchDelivery',
              name: 'popBatchDeliveryOrder',
              component: './PopOrderManage/batchDelivery',
            },
            {
              title: $t('merchant.admin.product.inventory'),
              path: '/popGoodsManage',
              name: 'popGoodsManage',
              icon: 'smile',
              component: './PopGoodsManage',
            },
            // ↑↑↑↑↑↑应付审计用的,假的,没有实际用处↑↑↑↑↑↑↑
            {
              component: './404',
            },
          ],
        },
        {
          component: './404',
        },
      ],
    },
    {
      component: './404',
    },
  ],
  // Theme for antd: https://ant.design/docs/react/customize-theme-cn
  theme: {
    'primary-color': primaryColor,
  },
  define: {
    'process.env.PRE_ENV': process.env.PRE_ENV,
    'process.env.SENTRY_ENV': process.env.SENTRY_ENV,
    ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION:
      ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION || '', // preview.pro.ant.design only do not use in your production ; preview.pro.ant.design 专用环境变量，请不要在你的项目中使用它。
  },
  ignoreMomentLocale: true,
  lessLoader: {
    javascriptEnabled: true,
  },
  cssLoader: {
    modules: {
      getLocalIdent: (context, _, localName) => {
        if (
          context.resourcePath.includes('node_modules') ||
          context.resourcePath.includes('ant.design.pro.less') ||
          context.resourcePath.includes('global.less')
        ) {
          return localName;
        }

        const match = context.resourcePath.match(/src(.*)/);

        if (match && match[1]) {
          const antdProPath = match[1].replace('.less', '');
          const arr = slash(antdProPath)
            .split('/')
            .map(a => a.replace(/([A-Z])/g, '-$1'))
            .map(a => a.toLowerCase());
          return `antd-pro${arr.join('-')}-${localName}`.replace(/--/g, '-');
        }

        return localName;
      },
    },
  },
  chunks: ['antdesigns', 'vendors', 'mapvgl', 'umi'],
  chainWebpack: webpackPlugin,
  nodeModulesTransform: {
    type: 'none',
  },
  /*
  proxy: {
    '/server/api/': {
      target: 'https://preview.pro.ant.design/',
      changeOrigin: true,
      pathRewrite: { '^/server': '' },
    },
  },
  */
};
