import { Modal, Table, Button } from 'antd';
import React, { Component } from 'react';
import styles from '../style.less';

class DetailModal extends Component {
  getColumns = (firstSpe, secondSpe, type) => {
    const arr = [
      {
        title: '供应商',
        dataIndex: 'supplierName',
        key: 'supplierName',
        align: 'center',
        width: 50,
        render: (val, row) => {
          const obj = {
            children: val,
            props: {},
          };
          if (row.listLength) {
            obj.props.rowSpan = row.listLength;
          } else {
            obj.props.rowSpan = 0;
          }
          return obj;
        },
      },
    ];
    if (firstSpe) {
      arr.push({
        title: firstSpe,
        dataIndex: 'firstSpecValue',
        key: 'firstSpecValue',
        align: 'center',
        width: 50,
        render: (val, row) => {
          const obj = {
            children: val,
            props: {},
          };
          if (row.length) {
            obj.props.rowSpan = row.length;
          } else {
            obj.props.rowSpan = 0;
          }
          return obj;
        },
      });
    }
    if (secondSpe) {
      arr.push({
        title: secondSpe,
        align: 'center',
        key: 'secondSpecValue',
        dataIndex: 'secondSpecValue',
        width: 50,
      });
    }
    const newTable = arr.concat([
      {
        title: '供应商编码',
        align: 'center',
        key: 'supplierCode',
        dataIndex: 'supplierCode',
        width: 50,
      },
      {
        title: '库存',
        align: 'center',
        key: 'stock',
        dataIndex: 'stock',
        width: 50,
      },
      {
        title: '供货价',
        align: 'center',
        key: 'supplyPrice',
        dataIndex: 'supplyPrice',
        width: 50,
      },
      {
        title: '市场价',
        align: 'center',
        key: 'marketPrice',
        dataIndex: 'marketPrice',
        width: 50,
      },
      {
        title: '国际编码',
        align: 'center',
        key: 'thirdSkuNo',
        dataIndex: 'thirdSkuNo',
        width: 50,
      },
    ]);
    if (type === 1) {
      newTable.splice(newTable.length - 1, 0, {
        title: '重量(kg)',
        align: 'center',
        key: 'weight',
        dataIndex: 'weight',
        width: 90,
      });
    }
    return newTable;
  };

  updateStatus = (row, productState) => {
    this.props.updateStatus(row, productState);
  };

  dataInit = list => {
    const obj = {};
    let finialList = [];
    list.map(item => {
      obj[item.firstSpecValue] = [];
      return obj;
    });
    list.map(item => obj[item.firstSpecValue].push(item));
    const keys = Object.keys(obj);
    // eslint-disable-next-line no-return-assign
    keys.map(key => {
      obj[key].forEach((i, index) => {
        if (index === 0) {
          i.length = obj[key].length;
        }
      });
      finialList = finialList.concat(obj[key]);
      return finialList;
    });
    if (finialList.length) {
      finialList[0].listLength = finialList.length;
    }

    return finialList;
  };

  render() {
    const { visible, data = [], type } = this.props;

    const initdata = this.dataInit(data);
    const firstName = data.length ? data[0].firstSpec : '';
    const secondName = data.length ? data[0].secondSpec : '';
    return (
      <Modal
        title="供货详情"
        visible={visible}
        footer={null}
        onCancel={this.props.onCancel}
        width="900px"
      >
        <Table
          dataSource={initdata}
          bordered
          columns={this.getColumns(firstName, secondName, type)}
          rowKey="id"
          pagination={false}
          scroll={{ x: '100%' }}
        />
        <Button type="primary" onClick={this.props.onCancel} className={styles.logBtn}>
          关闭
        </Button>
      </Modal>
    );
  }
}

export default DetailModal;
