import React, { useState, useRef } from 'react';
import { Button, notification } from 'antd';
import ProTable from '@ant-design/pro-table';
// import { searchList, auditInfoApi, orderDetail } from './service';
import { searchList, orderDetail } from './service';
import { column } from './data';
import AuditModal from './components/auditModal';
import DetailTable from './components/detailTable';
import { dateDiff } from './common';

export default () => {
  const table = useRef();
  const [visible, setVisible] = useState(false);
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const [auditInfo, setAuditInfo] = useState({});
  // const dateDiff = (startTime, endTime) => {
  //   const startY = startTime.substr(0, 4);
  //   const startM = startTime.substr(5, 2);
  //   const startD = startTime.substr(8, 2);
  //   const endY = endTime.substr(0, 4);
  //   const endM = endTime.substr(5, 2);
  //   const endD = endTime.substr(8, 2);
  //   if (endY - startY > 0) {
  //     if (
  //       (endY - startY) * (12 - startM) + endM > 3 ||
  //       ((endY - startY) * (12 - startM) + endM === 3 && endD > startD)
  //     ) {
  //       return true;
  //     }
  //   } else if (endM - startM > 3 || (endM - startM === 3 && endD > startD)) {
  //     return true;
  //   }
  //   return false;
  // };

  const query = async (params, type) => {
    if (params.orderId) {
      params.orderId = `${params.orderId}`.replace(/\s/g, '');
    }
    if (params.receiverPhone) {
      const reg = /^1[3456789]\d{9}$/;
      if (!reg.test(params.receiverPhone)) {
        notification.warning({
          message: '您输入的手机号有误，请重新输入！',
        });
        return false;
      }
    }
    if (params.orderTime && params.orderTime.length) {
      const startTime = params.orderTime[0];
      const endTime = params.orderTime[1];
      if (dateDiff(startTime, endTime)) {
        notification.warning({
          message: '您输入的订单创建时间超过3个月啦！',
        });
        return false;
      }
    }
    if (params.applyTime && params.applyTime.length) {
      const startTime = params.applyTime[0];
      const endTime = params.applyTime[1];
      if (dateDiff(startTime, endTime)) {
        notification.warning({
          message: '您输入的订单提交时间超过3个月啦！',
        });
        return false;
      }
    }
    const tempParams = {
      ...params,
      applyTimeStartAt: params.applyTime?.[0],
      applyTimeEndAt: params.applyTime?.[1],
      orderTimeStartAt: params.orderTime?.[0],
      orderTimeEndAt: params.orderTime?.[1],
      auditStatus: 1,
    };

    return searchList(tempParams, type);
  };

  const viewDetail = async ({ serviceNo }) => {
    const data = await orderDetail({ serviceNo });
    setDetailInfo(data || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
  };
  const openAudit = async ({ serviceNo }) => {
    // const data = await auditInfoApi({ serviceNo });
    setAuditInfo({ serviceNo });
    setVisible(true);
  };
  const columns = [
    ...column,
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 250,
      fixed: 'right',
      render: (_, r) => [
        <Button key="link1" onClick={() => openAudit(r)} className="mr10" type="primary">
          审核
        </Button>,
        <Button key="link" onClick={() => viewDetail(r)} type="primary">
          订单详情
        </Button>,
      ],
    },
  ];
  return (
    <div>
      <ProTable
        columns={columns}
        request={params => query(params, 1)}
        rowKey="serviceNo"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%', y: 400 }}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        toolBarRender={false}
      />
      <AuditModal visible={visible} onCancel={closeModal} formData={auditInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
    </div>
  );
};
