import { getMenuData } from '@/services/menu';

const MenuModel = {
  namespace: 'menu',
  state: {
    menuData: [
      {
        path: '/',
        name: '主页',
        icon: 'home',
        key: '',
      },
    ],
  },
  effects: {
    *getMenuData({ payload }, { put, call }) {
      const response = yield call(getMenuData, payload);
      if (response.code === 2000) {
        // 拿到数据后response.data后组装成新的数据复制给menuData
        yield put({
          type: 'save',
          payload: response.data,
        });
      }
    },
  },
  reducers: {
    save(state, { payload }) {
      const initializationData = tableData => {
        const value = [];
        const data = [...tableData];
        data
          .filter(item => item.node && item.node.uri !== '/systemManage')
          .forEach(item => {
            let obj = {};
            obj = { ...item.node };
            obj.path = obj.uri;
            obj.icon = obj.picture;
            obj.name = obj.name;
            if (item.childNodes.length) {
              obj.children = initializationData(item.childNodes);
            } else {
              obj.children = [];
            }
            value.push(obj);
          });
        return value;
      };
      let menuData = initializationData(payload);
      menuData = menuData.concat([
        {
          path: 'auditPending',
          icon: 'smile',
          name: '售后未审核',
        },
        {
          path: 'passAudit',
          icon: 'smile',
          name: '售后已审核',
        },
      ]);
      return { ...state, menuData };
    },
  },
};
export default MenuModel;
