import { Button } from 'antd';
import React from 'react';

export const activeStateEnum = {
  10: { text: '销售' },
  20: { text: '售后' },
};

export const orderStateNum = {
  1: { text: '待确认' },
  2: { text: '已确认' },
  3: { text: '已生成结算单' },
};

export const columns = [
  {
    title: '序号',
    dataIndex: 'index',
    hideInSearch: true,
    width: '50px',
    render: (text, record, index) => `${index + 1}`,
  },
  {
    title: '供应商名称',
    dataIndex: 'supplierName',
    width: '150px',
    hideInSearch: true,
  },
  {
    title: '结算单批次号',
    dataIndex: 'settleBatchNo',
    width: '160px',
  },
  {
    title: '账单日期',
    key: 'dateTimeRange',
    dataIndex: 'createdAtRange',
    valueType: 'dateTimeRange',
    width: '120px',
    hideInTable: true,
    initialValue: [],
    align: 'center',
  },
  {
    title: '账单日期',
    dataIndex: 'billDateStr',
    key: 'billDateStr',
    hideInSearch: true,
    align: 'center',
    width: '160px',
  },
  {
    title: '账单类型',
    dataIndex: 'billType',
    valueEnum: activeStateEnum,
    width: '120px',
    filters: false,
  },
  {
    title: '金额',
    dataIndex: 'amount',
    width: '100px',
    hideInSearch: true,
  },
  {
    title: '笔数',
    dataIndex: 'quantity',
    width: '100px',
    hideInSearch: true,
  },
  {
    title: '状态',
    dataIndex: 'status',
    valueEnum: orderStateNum,
    width: '100px',
    filters: false,
  },
];

export const toolBarRender = gather => {
  const { onDownload, confirmAction } = gather;
  return () => [
    <Button type="primary" style={{ marginRight: '20px' }} onClick={onDownload}>
      下载
    </Button>,
    <Button type="primary" onClick={confirmAction}>
      确认
    </Button>,
  ];
};
