import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import config from '../../../../config/env.config';

// 查询订单列表
export async function queryOrderList(params) {
  return request.post('/api/merchants/orders/poplist', {
    prefix: config.kdspApi,
    data: params,
  });
}
// 订单详情
export async function queryOrderDetail(params) {
  return request.post('/api/merchants/orders/popdetail', {
    prefix: config.kdspApi,
    data: params,
  });
}
// 待发货订单
export async function queryToSend(params) {
  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/merchants/orders/list', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(params, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}

//  发货/更新物流
export async function updateExpress(params) {
  return request.post('/api/merchants/orders/deliveries/add', {
    prefix: config.kdspApi,
    data: params,
  });
}

// 快递公司
export async function queryExpress() {
  try {
    const { data } = await request.get('/api/merchants/companies/list', {
      prefix: config.kdspApi,
    });
    return data;
  } catch (error) {
    return {};
  }
}

export async function getGoods(orderId) {
  const { data } = await request.get(`/api/merchants/orders/skus/list?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
