import { getMenuData } from '@/services/menu';

const MenuModel = {
  namespace: 'menu',
  state: {
    menuData: [
      {
        path: '/',
        name: '主页',
        icon: 'home',
        key: '',
      },
    ],
  },
  effects: {
    *getMenuData({ payload }, { put, call }) {
      const response = yield call(getMenuData, payload);
      if (response.code === 2000) {
        // 拿到数据后response.data后组装成新的数据复制给menuData
        yield put({
          type: 'save',
          payload: response.data,
        });
      }
    },
  },
  reducers: {
    save(state, { payload }) {
      const initializationData = tableData => {
        const value = [];
        const data = [...tableData];
        data
          .filter(item => item.node && item.node.uri !== '/systemManage')
          .forEach(item => {
            let obj = {};
            obj = { ...item.node };
            obj.path = obj.uri;
            obj.icon = obj.picture;
            obj.name = obj.name;
            if (item.childNodes.length) {
              obj.children = initializationData(item.childNodes);
            } else {
              obj.children = [];
            }
            value.push(obj);
          });
        return value;
      };
      const menuData = initializationData(payload);
      menuData.push({
          icon: "laptop",
          id: "47291f3a-dfd8-4c4e-8fa8-5cf262ccf9a2",
          name: "订单管理",
          path: "/orderManage",
          picture: "laptop",
          type: {name: "资源组", value: 1},
          uri: "/operation",
          children: [{
            icon: "reconciliation",
            id: "169e18a2-0b65-465e-a090-f9b2edc442f3",
            name: "待发货订单",
            path: "/orderManage/pendingDeliveryOrder",
            picture: "reconciliation",
            type: {name: "菜单", value: 2},
            uri: "/operation/operationCheck",
          }],
        });
      return { ...state, menuData};
    },
  },
};
export default MenuModel;
