import React, { useState, useRef, useEffect } from 'react';
import { Button } from 'antd';
import ProTable from '@ant-design/pro-table';
import { searchList, orderDetail } from './service';
import { column } from './data';
import DetailTable from './components/detailTable';

export default () => {
  const table = useRef();
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const viewDetail = async ({ serviceNo }) => {
    const data = await orderDetail({ serviceNo });
    setDetailInfo(data || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setDetailVisible(false);
  };

  const query = async (params, type) => {
    const tempParams = {
      ...params,
      applyTimeStartAt: params.applyTime?.[0],
      applyTimeEndAt: params.applyTime?.[1],
      orderTimeStartAt: params.orderTime?.[0],
      orderTimeEndAt: params.orderTime?.[1],
      auditStatus: 2,
    };

    return searchList(tempParams, type);
  };
  const columns = [
    ...column,
    {
      title: '操作',
      hideInSearch: true,
      width: 150,
      dataIndex: 'action',
      fixed: 'right',
      render: (_, r) => [
        <Button key="link3" onClick={() => viewDetail(r)} type="primary" className="mr10">
          订单详情
        </Button>,
      ],
    },
  ];
  useEffect(() => {
    query(
      {
        current: 1,
        pageSize: 20,
      },
      2,
    );
  });
  return (
    <div>
      <ProTable
        key="passaudit"
        columns={columns}
        request={params => query(params, 2)}
        rowKey="skuId"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%', y: 400 }}
        toolBarRender={false}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
      />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
    </div>
  );
};
