import { Modal, Form, Select, Input, InputNumber } from 'antd';
import React, { Component } from 'react';

const FormItem = Form.Item;

class formModal extends Component {
  componentDidMount() {
    this.props.onRef(this);
  }

  handleOk = () => {
    this.props.form.validateFields((err, fieldsValue) => {
      if (err) return;
      const value = {
        ...fieldsValue,
        id: this.props.initForm.id ?? '',
      };
      this.props.submit(value);
    });
  };

  resetFields = () => {
    this.props.form.resetFields();
  };

  render() {
    const {
      visible,
      form: { getFieldDecorator },
      statusList = [],
      initForm = {},
    } = this.props;
    const InputNumStyle = { width: '100%' };
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 5 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 17 },
      },
    };
    const options =
      statusList.length &&
      statusList.map(d => (
        <Select.Option value={d.status} key={d.status}>
          {d.statusDesc}
        </Select.Option>
      ));
    return (
      <Modal
        title="商品信息修改"
        visible={visible}
        onCancel={this.props.onCancel}
        onOk={this.handleOk}
      >
        <Form name="detail" {...formItemLayout}>
          <FormItem label="sku编码">
            {getFieldDecorator('skuNo', {
              initialValue: initForm.skuNo,
            })(<Input readOnly />)}
          </FormItem>
          <FormItem label="商品名称">
            {getFieldDecorator('skuName', {
              initialValue: initForm.skuName,
              rules: [{ required: true, message: '请输入商品名称' }],
            })(<Input allowClear />)}
          </FormItem>
          <FormItem label="商品规格">
            {getFieldDecorator('attValue', {
              initialValue: initForm.attValue,
              rules: [{ message: '请输入商品规格' }],
            })(<Input allowClear />)}
          </FormItem>
          <FormItem label="成本价">
            {getFieldDecorator('costPrice', {
              initialValue: initForm.costPrice,
              rules: [{ required: true, message: '请输入成本价' }],
            })(<InputNumber allowClear precision={2} style={InputNumStyle} />)}
          </FormItem>
          {/* <FormItem label="市场价">
            {getFieldDecorator('marketPrice', {
              initialValue: initForm.marketPrice,
              rules: [{ required: true, message: '请输入市场价' }],
            })(<InputNumber allowClear style={InputNumStyle} precision={2} />)}
          </FormItem>
          <FormItem label="销售价">
            {getFieldDecorator('salePrice', {
              initialValue: initForm.salePrice,
              rules: [{ required: true, message: '请输入销售价' }],
            })(<InputNumber allowClear style={InputNumStyle} precision={2} />)}
          </FormItem> */}
          <FormItem label="库存">
            {getFieldDecorator('stock', {
              initialValue: initForm.stock,
              rules: [{ required: true, message: '请输入库存' }],
            })(<InputNumber allowClear style={InputNumStyle} />)}
          </FormItem>
          <FormItem label="商品状态">
            {getFieldDecorator('status', {
              initialValue: initForm.status,
              rules: [{ required: true, message: '请输入商品状态' }],
            })(<Select allowClear>{options}</Select>)}
          </FormItem>
        </Form>
      </Modal>
    );
  }
}

export default Form.create()(formModal);
