import React, { useEffect, useState } from 'react';
import { getSpecList } from '../service';

export const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 2 },
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 22 },
  },
};

export const useModalTitle = isEdit => {
  const titleText = isEdit ? '修改商品' : '新增商品';
  return [titleText];
};

export const useSpecList = () => {
  const [specList, setSpecList] = useState([]);
  useEffect(() => {
    const featchData = async () => {
      const { data = [] } = await getSpecList();
      setSpecList(data);
    };
    featchData();
  }, []);
  return [specList];
};

export const filterSpecId = (input, option) =>
  option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0;

export const useEditProduct = () => [1];

export const dataInit = list => {
  if (!list || !list.length) return;
  const obj = {};
  let finialList = [];
  list.forEach(item => {
    obj[item.firstSpecValue] = [];
  });
  list.forEach(item => obj[item.firstSpecValue].push(item));
  const keys = Object.keys(obj);
  keys.forEach(key => {
    obj[key].forEach((i, index) => {
      if (index === 0) {
        i.length = obj[key].length;
      }
    });
    finialList = finialList.concat(obj[key]);
    return finialList;
  });
};
