import React, { useState } from 'react';
import { Table, Form, InputNumber, Input, Popconfirm, Button, notification } from 'antd';
import { useEditProduct, dataInit } from './utils';

const initData = {
  weight: null,
  productStockWarning: null,
  marketPrice: 'marketPrice',
  // salePrice: '',
  supplyPrice: 'supplyPrice',
  // stock: '',
  productStock: 'productStock',
  thirdSkuNo: 'thirdSkuNo',
  skuLink: 'skuLink',
  imageList: [],
};

const createProductData = (
  { firstValues, secondValues, firstSpecId, secondSpecId },
  productData,
) => {
  const countRowSpan = {};
  const dataSource = [];
  firstValues.forEach((fisrtItem, index) => {
    const specFirst = Object.assign({}, initData);
    specFirst.firstSpecId = firstSpecId.key;
    specFirst.firstSpecValue = fisrtItem;

    if (secondValues.length) {
      secondValues.forEach(secondItem => {
        const specSecond = Object.assign({}, specFirst);
        if (!countRowSpan[specFirst.firstSpecValue]) {
          countRowSpan[specFirst.firstSpecValue] = true;
          specSecond.rowSpanCount = secondValues.length;
        }
        specSecond.secondSpecId = secondSpecId.key;
        specSecond.secondSpecValue = secondItem;
        dataSource.push(specSecond);
      });
      return;
    }
    dataSource.push(specFirst);
  });
  return dataSource;
};

const isRepeatProduct = (list, message) => {
  const isRepeat = [...new Set(list)].length !== list.length;
  if (isRepeat) {
    notification.warning({ message });
  }
  return isRepeat;
};

const EditableContext = React.createContext();

const EditableCell = tableProps => {
  const getInput = () => {
    if (tableProps.inputType === 'number') {
      return <InputNumber />;
    }
    return <Input />;
  };
  const renderCell = form => {
    const { getFieldDecorator } = form;
    const {
      editable,
      dataIndex,
      title,
      inputType,
      record,
      index,
      children,
      rules,
      required,
      ...restProps
    } = tableProps;
    console.log(tableProps);
    return (
      <td {...restProps}>
        {editable ? (
          <Form.Item style={{ margin: 0 }}>
            {getFieldDecorator(`tableArray[${index}][${dataIndex}]`, {
              rules: [
                {
                  required,
                  message: `请输入 ${title}!`,
                },
                ...rules,
              ],
              initialValue: record[dataIndex],
            })(getInput())}
          </Form.Item>
        ) : (
          <Form.Item style={{ margin: 0 }}>
            {getFieldDecorator(`tableArray[${index}][${dataIndex}]`, {
              initialValue: record[dataIndex],
            })(<span className="ant-form-text">{children}</span>)}
          </Form.Item>
        )}
      </td>
    );
  };
  return <EditableContext.Consumer>{renderCell}</EditableContext.Consumer>;
};

const ProductInfoColumns = ({ firstSpecId, secondSpecId }, productData) => {
  console.log(productData);
  return productData.length
    ? [
        {
          title: firstSpecId?.label,
          dataIndex: 'firstSpecValue',
          key: 'firstSpecValue',
          editable: false,
          render: (val, row) => ({
            children: val,
            props: {
              rowSpan: row.rowSpanCount ? row.rowSpanCount : 0,
            },
          }),
        },
        {
          title: secondSpecId?.label,
          dataIndex: 'secondSpecValue',
          key: 'secondSpecValue',
          editable: false,
        },
        {
          title: '供货价',
          key: 'supplyPrice',
          dataIndex: 'supplyPrice',
          editable: true,
          inputType: 'number',
          required: true,
          rules: [],
        },
        {
          title: '市场价',
          key: 'marketPrice',
          dataIndex: 'marketPrice',
          editable: true,
          required: true,
        },
        {
          title: '库存',
          dataIndex: 'productStock',
          key: 'productStock',
          editable: true,
          inputType: 'number',
          required: true,
        },
        {
          title: '商品自编码',
          dataIndex: 'thirdSkuNo',
          key: 'thirdSkuNo',
          editable: true,
          inputType: 'number',
          required: true,
        },
        {
          title: '京东链接',
          dataIndex: 'skuLink',
          key: 'skuLink',
          editable: true,
        },
      ]
    : [];
};

const BatchSettings = () => {};

export const GenerateProductInfo = ({ form }) => {
  const [productData, setProductData] = useState([]);
  const components = {
    body: {
      cell: EditableCell,
    },
  };

  const columns = ProductInfoColumns(form.getFieldsValue(), productData).map(col => {
    console.log('============================================================');
    return {
      ...col,
      onCell: (record, index) => {
        console.log(index);
        return {
          index,
          record,
          editable: col.editable,
          dataIndex: col.dataIndex,
          title: col.title,
          rules: col.rules,
          required: col.required,
        };
      },
    };
  });

  const handleAddProduct = () => {
    const values = form.getFieldsValue();
    const { firstValues = [], secondValues = [] } = values;
    // 校验是否有重复的一级规格
    const fisrtIsRepeat = isRepeatProduct(firstValues, '一级规格不可重复');
    const secondIsRepeat = isRepeatProduct(secondValues, '二级规格不可重复');
    if ([fisrtIsRepeat, secondIsRepeat].includes(true)) {
      setProductData([]);
      return;
    }

    const newData = createProductData(values, productData);
    setProductData(newData);
  };
  return (
    <EditableContext.Provider value={form}>
      <div style={{ textAlign: 'center' }}>
        <Button onClick={handleAddProduct} type="primary" style={{ marginBottom: 16 }}>
          生成商品信息
        </Button>
        {/* <BatchSettings /> */}
      </div>
      <Table
        rowKey="id"
        pagination={false}
        components={components}
        bordered
        dataSource={productData}
        columns={columns}
        rowClassName="editable-row"
      />
    </EditableContext.Provider>
  );
};
