import React, { useState, useRef } from 'react';
import { ProTable } from '@ant-design/pro-components';
import { Button, Space } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { takeawayGoodsColumn } from './staticData/goods';
import utilStyle from '@/utils/utils.less';
import { apiTakeawayList } from './service/api';
import SaleDateModal from './components/SaleDateModal';

const BusinessCustomer = () => {
  const [visibleSaleDate, setVisibleSaleDate] = useState(true); // 可售日期弹窗
  const [visibleSaleSection, setVisibleSaleSection] = useState(true); // 可售餐段弹窗
  const [visiblePrice, setVisiblePrice] = useState(true); // 修改企业商品价格弹窗
  const [visibleSort, setVisibleSort] = useState(true); // 商品排序弹窗
  const [visibleGoods, setVisibleGoods] = useState(true); // 添加外卖商品弹窗
  const [activeKey, setActiveKey] = useState('tab1');
  const query = async params => {
    console.log('params :>> ', params);
    const data = {
      page: params.current,
      size: params.pageSize,
      data: params,
    };
    return apiTakeawayList(data);
  };
  const onDel = async () => {};
  const onAdd = async () => {};
  const options = {
    setVisibleSaleDate,
    setVisibleSaleSection,
    setVisiblePrice,
    setVisibleSort,
    setVisibleGoods,
    onDel,
  };

  return (
    <div>
      <ProTable
        search={{
          span: 6,
          className: utilStyle.formSearch,
          collapsed: false,
          collapseRender: () => null,
        }}
        tableClassName={utilStyle.formTable}
        columns={takeawayGoodsColumn(options)}
        request={params => query({ ...params })}
        rowKey={r => r.id}
        expandIconColumnIndex={10}
        bordered
        options={false}
        toolbar={{
          menu: {
            type: 'tab',
            activeKey,
            items: [
              {
                key: 'tab1',
                label: <span>取餐点1</span>,
              },
              {
                key: 'tab2',
                label: <span>取餐点2</span>,
              },
              {
                key: 'tab3',
                label: <span>取餐点3</span>,
              },
            ],
            onChange: key => {
              setActiveKey(key);
            },
          },
          actions: [
            <Button key="1" icon={<PlusOutlined />} type="primary" onClick={onAdd}>
              添加外卖商品
            </Button>,
          ],
        }}
        scroll={{ x: '100%', y: 400 }}
      />
      {visibleSaleDate && (
        <SaleDateModal visible={visibleSaleDate} close={() => setVisibleSaleDate(false)} />
      )}
    </div>
  );
};

export default BusinessCustomer;
