import React, { useState } from 'react';
import { Form, Input, Radio, Space, Col, Row, Modal } from 'antd';
import { ExclamationCircleOutlined } from '@ant-design/icons';
import { jsonToArray } from '@/utils/utils';
import { weekOptions } from '../staticData/goods';

const SaleDateModal = props => {
  const [form] = Form.useForm();
  const [value, setValue] = useState(1);

  // 关闭分组信息弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeWeek = e => {
    setValue(e.target.value);
  };

  // 添加/保存分组
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
  };

  console.log('visible :>> ', props.visible);

  return (
    <Modal
      title="设置可售日期"
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="200px"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Radio.Group onChange={onChangeWeek} value={value}>
        <Space direction="vertical">
          {Object.keys(weekOptions).map(key => (
            <Radio value={key}>{weekOptions[key]}</Radio>
          ))}
        </Space>
      </Radio.Group>
    </Modal>
  );
};
export default SaleDateModal;
