import React, { useState, useRef, useEffect } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { Button, Image } from 'antd';
import { saveAs } from 'file-saver';
import { columnsConfig, getLastItem, checkImage } from './staticdata';
import { getQueryClamsList } from './service';
import ClaimDescription from './ClaimDescription';

/**
 * 售后赔款单
 * 售后赔款单
 * @param {*} router options
 * @returns ReactDOM
 */
const AfterSalesClaimForm = ({ route }) => {
  const ref = useRef();
  const actionRef = useRef();
  const [claimVisible, setclaimVisible] = useState(false);
  const [claimLoading, setclaimLoading] = useState(false);
  const [imagePreView, setImagePreView] = useState({
    src: '',
    visible: false,
  });
  const search = {
    collapsed: false,
    collapseRender: () => null,
  };

  const query = async params => {
    const { createdAt, singleType, singleNumber, current: pageNo, ...other } = params;
    const queryParams = { ...other, pageNo };
    if (singleType && singleNumber) {
      if (+singleType === 0) queryParams.id = singleNumber;
      if (+singleType === 1) queryParams.orderNo = singleNumber;
    }
    if (createdAt?.length) {
      const [startTime, endTime] = createdAt;
      queryParams.startTime = startTime;
      queryParams.endTime = endTime;
    }
    const { data } = await getQueryClamsList(queryParams);
    return {
      total: data.total,
      data: data?.records,
    };
  };

  const openSetclaimModal = async (row, audit) => {
    setclaimLoading(true);
    setclaimVisible(true);
    setclaimLoading(false);
  };

  const closeClaimDescription = () => {
    setclaimVisible(false);
  };

  const refreshTable = () => {
    ref.current.reload();
  };
  // eslint-disable-next-line consistent-return
  const downLoadFile = async url => {
    if (await checkImage(url)) {
      setImagePreView({ src: url, visible: true });
      return null;
    }
    saveAs(url, getLastItem(url));
  };

  // const toolBarRender = () => [
  //   <Button type="link" onClick={openSetclaimModal}>
  //     赔款说明
  //   </Button>,
  // ];
  // toolBarRender={toolBarRender}

  const onReset = () => {};

  return (
    <PageHeaderWrapper>
      <ProTable
        bordered
        loading={claimLoading}
        type="cardList"
        request={query}
        tableClassName="capital"
        columns={columnsConfig({ downLoadFile })}
        rowKey={row => row.id}
        search={search}
        options={false}
        actionRef={ref}
        pagination={{ pageSize: 10 }}
        onReset={onReset}
        scroll={{ x: '100%', y: 430 }}
      />
      <ClaimDescription
        refresh={refreshTable}
        claimVisible={claimVisible}
        wrappedComponentRef={actionRef}
        closeClaimDescription={closeClaimDescription}
      />
      <Image
        width={200}
        style={{ display: 'none' }}
        src={imagePreView.src}
        preview={{
          visible: imagePreView.visible,
          scaleStep: '1',
          src: imagePreView.src,
          onVisibleChange: value => {
            setImagePreView({
              src: '',
              visible: false,
            });
          },
        }}
      />
    </PageHeaderWrapper>
  );
};

export default AfterSalesClaimForm;
