/* eslint-disable consistent-return */
import React, { forwardRef, useContext, useState, useEffect, useImperativeHandle } from 'react';
import { Form, Select, Row, Col, Button } from 'antd';
import { UpOutlined, DownOutlined } from '@ant-design/icons';
import { ServiceContext } from '../context';
import styles from '../common.less';
import { apiGetAttribute } from '../service';
import CustomSelect from '@/components/CustomSelect';

const FormAttr = forwardRef((props, ref) => {
  const customer = useContext(ServiceContext);
  const [form] = Form.useForm();
  const [isMore, setIsMome] = useState(false);
  const [categoryAttrs, setCategoryAttrs] = useState([]);
  const [skuOldAttr, setSkuOldAttr] = useState([]);

  const formItemAttr = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };

  const onChangeMore = () => {
    setIsMome(!isMore);
  };

  // 获取属性
  const getAttribute = async categoryId => {
    const res = await apiGetAttribute(categoryId);
    if (res && res.data && res.data.length) {
      setCategoryAttrs(res.data);
    }
  };

  // 验证是否失效属性（已失效的商品不显示）
  const checkInAttrList = id => categoryAttrs.some(item => item.valueList.some(v => +v.id === +id));

  // 获取初始化属性数据
  const getInitAttrValue = () => {
    const skuAttr = props.initData.productAttributeApplyList?.productAttributeApplyList || [];
    const attrs = [];
    if (customer.isEdit) {
      categoryAttrs.forEach(({ id, supportCustomValue, optionType }) => {
        const v = skuAttr.filter(item => id === item.productAttributeId);
        let values = '';
        const key = 'productAttributeApplyValueList';
        if (v.length && v[0][key] && v[0][key].length) {
          values = [];
          if (+supportCustomValue.code === 1 || +optionType.code === 2) {
            v[0][key].forEach(attr => {
              if (+attr.attributeValueId) {
                checkInAttrList(attr.attributeValueId) &&
                  values.push(
                    JSON.stringify({
                      attributeValueId: attr.attributeValueId,
                      attributeValueName: attr.attributeValueName,
                    }),
                  );
              } else {
                values.push(attr.attributeValueName);
              }
            });
          } else if (v[0][key].length) {
            const atvalue = v[0][key][0];
            if (checkInAttrList(atvalue.attributeValueId)) {
              values = JSON.stringify({
                attributeValueId: atvalue.attributeValueId,
                attributeValueName: atvalue.attributeValueName,
              });
            }
          }
        }
        attrs.push({
          [id]: values,
        });
      });
    }
    return attrs;
  };

  // 获取下拉框类型
  const getMode = optionType => (+optionType.code === 2 ? 'multiple' : 'default');

  // 获取下拉框校验
  const getAttrRules = k => {
    if (+k.required.code === 1) {
      return [
        {
          required: true,
          type: +k.optionType.code === 2 ? 'array' : 'string',
          message: '请选择',
        },
      ];
    }
    return [];
  };

  // 处理下拉框返回值
  const deal = attr => {
    try {
      const json = JSON.parse(attr);
      if (typeof json === 'object') {
        json.attributeValueName = json.name;
        return json;
      }
      return { attributeValueName: json.name };
    } catch {
      return { attributeValueName: attr };
    }
  };

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      const attributeApplyList = [];
      // eslint-disable-next-line no-restricted-syntax
      for (const key in values) {
        if (values.hasOwnProperty(key)) {
          let attrs = values[key];
          if (Array.isArray(values[key])) {
            attrs = [];
            values[key].forEach(attr => {
              const json = deal(attr);
              json && attrs.push(json);
            });
          } else {
            const json = deal(values[key]);
            json && (attrs = [json]);
          }
          attributeApplyList.push({
            attributeId: key,
            attributeApplyValueList: attrs,
          });
        }
      }
      const v = {
        temp: 'attributeApplyList',
        attributeApplyList,
      };
      return v;
    } catch (errorInfo) {
      return null;
    }
  };

  useEffect(() => {
    const ids = props.categoryIds;
    if (ids && ids.length) {
      getAttribute(ids[ids.length - 1]);
    }
  }, [props.categoryIds]);

  useEffect(() => {
    if (props.editData && props.editData.productAttributeApplyList?.oldProductAttributeApplyList) {
      const oattr = props.editData.productAttributeApplyList;
      setSkuOldAttr((oattr && oattr.oldProductAttributeApplyList) || []);
    }
  }, [props.editData]);

  useImperativeHandle(ref, () => ({
    onCheck,
    reset: form.resetFields,
  }));

  return (
    <>
      <div className={styles.attrbox + (isMore ? styles.attrboxMore : '')}>
        <Form form={form} initialValues={getInitAttrValue()}>
          <Row>
            {categoryAttrs.length > 0 &&
              categoryAttrs.map(k => (
                <Col span={12} key={k.id}>
                  <Form.Item
                    label={k.name}
                    name={k.id}
                    {...formItemAttr}
                    key={k.id}
                    rules={getAttrRules(k)}
                  >
                    <CustomSelect
                      options={k.valueList || []}
                      isCustom={+k.supportCustomValue.code === 1}
                      mode={getMode(k.optionType)}
                    />
                  </Form.Item>
                </Col>
              ))}
          </Row>
        </Form>
      </div>
      {categoryAttrs.length > 12 && (
        <div className={styles.btnMore}>
          <Button type="link" onClick={onChangeMore}>
            {isMore ? (
              <>
                收起 <UpOutlined />
              </>
            ) : (
              <>
                展示更多 <DownOutlined />
              </>
            )}
          </Button>
        </div>
      )}
      {skuOldAttr.length > 0 && (
        <div>
          <Row>注：以下商品属性已失效，请使用新的属性</Row>
          <Row>
            {skuOldAttr.map(s => (
              <Col span={12} key={s.id}>
                <Form.Item
                  label={s.productAttributeName}
                  {...formItemAttr}
                  required={false}
                  key={s.id}
                >
                  {s.productAttributeApplyValueList.map(item => item.attributeValueName).join('；')}
                </Form.Item>
              </Col>
            ))}
          </Row>
        </div>
      )}
    </>
  );
});

export default FormAttr;
