import { Tooltip } from 'antd';
import React from 'react';
import { NotificationOutlined } from '@ant-design/icons';
import { connect } from 'dva';
import Avatar from './AvatarDropdown';
import HeaderSearch from '../HeaderSearch';
import styles from './index.less';
import MessageIcon from './MessageIcon';

const GlobalHeaderRight = props => {
  const { theme, layout, messageReminderComplexRef } = props;
  let className = styles.right;

  if (theme === 'dark' && layout === 'topmenu') {
    className = `${styles.right}  ${styles.dark}`;
  }

  return (
    <div className={className}>
      <MessageIcon messageReminderComplexRef={messageReminderComplexRef} />
      <Avatar />
    </div>
  );
};

export default connect(({ settings }) => ({
  theme: settings.navTheme,
  layout: settings.layout,
}))(GlobalHeaderRight);
