import { Modal, Input, notification } from 'antd';
import React, { Component } from 'react';

const { TextArea } = Input;

// eslint-disable-next-line react/prefer-stateless-function
class reasonModal extends Component {
  state = {
    remarks: '',
  };

  inputChange = ({ target: { value } }) => {
    this.setState({ remarks: value });
  };

  onCancel = () => {
    this.setState({ remarks: '' });
    this.props.onCancel();
  };

  submit = () => {
    if (!this.state.remarks) {
      notification.error({
        message: '请输入下架原因',
      });
      return;
    }
    this.props.submit(this.state.remarks);
    this.setState({ remarks: '' });
  };

  render() {
    const { visible } = this.props;
    return (
      <Modal
        title="下架原因"
        visible={visible}
        onOk={this.submit}
        onCancel={() => this.onCancel()}
        width="700px"
      >
        <div>
          <TextArea value={this.state.remarks} rows={4} onChange={this.inputChange} />
        </div>
      </Modal>
    );
  }
}

export default reasonModal;
