import { Tabs } from 'antd';
import React from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { AFTER_SALE_ORDER } from '@/../config/permission.config';
import { connect } from 'dva';
import Pending from './Pending';
import PassAudit from './PassAudit';

const { TabPane } = Tabs;

function AfterSale(props) {
  const { permissions } = props;
  const canEditable = permissions[AFTER_SALE_ORDER.EDITABLE.id];
  return (
    <PageHeaderWrapper>
      <Tabs defaultActiveKey="1">
        <TabPane tab="未审核" key="1">
          <Pending canEditable={canEditable} />
        </TabPane>
        <TabPane tab="已审核" key="2">
          <PassAudit canEditable={canEditable} />
        </TabPane>
      </Tabs>
    </PageHeaderWrapper>
  );
}

export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(AfterSale);
