/**
 * 从别的平台进入角色判断
 */
// 从tob进入的判断接口前缀
const getUrlParams = name => {
  const regArg = new RegExp(`(^|&)${name}=([^&]*)(&|$)`);
  const r = window.location.search.substring(1).match(regArg);
  if (r != null) return decodeURIComponent(r[2]);
  return null;
};

export const apiType = {
  platform: '/api/consoles',
  enterprise: '/api/enterprises',
  pop: '/api/consoles',
};

// role 类型 (platform:平台, enterprise:企业, pop:pop商)
export const RolePlatform = 'platform'; // 平台
export const RoleEnterprise = 'enterprise'; // 企业
export const RolePop = 'pop'; // pop商
export const UserRole = getUrlParams('role') || '';
export const isPlatForm = UserRole === RolePlatform;
export const apiPrefix = apiType[UserRole];
const RoleType = {
  RolePlatform,
  RoleEnterprise,
  RolePop,
  apiPrefix,
  isPlatForm,
  UserRole,
};
export default RoleType;
