import React, { useState, createContext } from 'react';
import { Modal, Table, Form } from 'antd';
import { column } from '../staticdata';
import styles from '../style.less';

/**
 * 更新供货价
 * * */
const UpdatePriceStock = options => {
  const [loading, setLoading] = useState(false);
  const [form] = Form.useForm();

  const onSubmit = async () => {
    const value = await form.validateFields();
    console.log('value :>> ', value);
    setLoading(true);
    setLoading(false);
    options.refresh();
    options.onCancel();
  };

  const EditableContext = createContext(null);

  return (
    <Modal
      title="修改供货价"
      open={options.visible}
      onCancel={options.onCancel}
      onOk={onSubmit}
      confirmLoading={loading}
      width={900}
      className={styles.priceStockTable}
      destroyOnClose
    >
      <Form form={form} scrollToFirstError component={false}>
        <EditableContext.Provider value={form}>
          <Table
            className={styles.priceStockTable}
            rowKey="key"
            columns={column.call(this)}
            dataSource={options.data}
          />
        </EditableContext.Provider>
      </Form>
    </Modal>
  );
};

export default UpdatePriceStock;
