import React from 'react';
import { Input, Form } from 'antd';
import styles from '../style.less';
import { isNumberSection, isCheckPriceTwoDecimal } from '@/utils/validator';

export function column() {
  return [
    {
      title: '供货价',
      dataIndex: 'supplyPrice',
      width: 150,
      align: 'center',
      render: (_, row, index) => (
        <div className={styles.price}>
          <Form.Item
            label=""
            key="supplyPrice"
            name={['data', index, 'supplyPrice']}
            initialValue={row.supplyPrice}
            rules={[
              { required: true, message: '请输入供货价！' },
              { validator: isCheckPriceTwoDecimal },
            ]}
          >
            <Input allowClear />
          </Form.Item>
        </div>
      ),
    },
    {
      title: '市场价',
      width: 135,
      align: 'center',
      dataIndex: 'marketPrice',
    },
    {
      title: '重量(kg)',
      width: 135,
      align: 'center',
      dataIndex: 'weight',
    },
    {
      title: '库存',
      width: 120,
      dataIndex: 'productStock',
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="productStock"
            name={['data', index, 'productStock']}
            initialValue={row.productStock}
            rules={[
              { required: true, message: '请输入库存！' },
              { validator: isNumberSection, min: 1, max: 500, message: '请输入1-500的整数' },
            ]}
          >
            <Input allowClear />
          </Form.Item>
        </div>
      ),
    },
    {
      title: '库存预警',
      width: 120,
      dataIndex: 'productStockWarning',
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="productStockWarning"
            name={['data', index, 'productStockWarning']}
            rules={[
              { required: true, message: '请输入库存！' },
              { validator: isNumberSection, min: 1, max: 500, message: '请输入1-500的整数' },
            ]}
            initialValue={row.productStockWarning}
          >
            <Input allowClear />
          </Form.Item>
        </div>
      ),
    },
    {
      title: '商品自编码',
      dataIndex: 'thirdSkuNo',
      width: 200,
      align: 'center',
    },
  ];
}
