import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { Button, Popconfirm, notification } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { actionStatus, settleStatus } from './data';
import style from './style.less';
import { query, updateStatus, download, docQuery } from './service';
import FileModal from './fileModal';
import UploadModal from './uploadModal';
import RemarkModal from './remarkModal';

export default () => {
  const protable = useRef();
  const remarkRef = useRef();
  const [showViewFile, setShowViewFile] = useState(false);
  const [viewFileData, setViewFileData] = useState([]);
  const [showViewUpload, setShowViewUpload] = useState(false);
  const [settlementNoV, setSettlementNo] = useState('');
  const [remarkShow, setRemarkShow] = useState(false);
  const [rowInfo, setRowInfo] = useState({});
  const reload = () => {
    if (protable?.current?.reload) {
      protable.current.reload();
    }
  };
  const confirmText = '您是否已确认结算金额是否正确？确认后无法撤回';
  const confirmAction = async (r, isRefuse, refuse) => {
    if (isRefuse && !refuse) {
      notification.error({ message: '请输入拒绝原因' });
      return;
    }
    const data = await updateStatus({
      id: r.id,
      status: isRefuse ? 4 : 3,
      remarks: isRefuse && refuse,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: '操作成功' });
      reload();
    }
  };
  const uploadInvoice = ({ settlementNo }) => {
    setSettlementNo(settlementNo);
    setShowViewUpload(true);
  };
  const downDetail = ({ settlementNo }) => {
    // type 1非财务 2财务
    download({ settlementNo, type: 1 });
  };
  const clearRefuseContent = r => {
    setRowInfo(r);
    if (remarkRef.current.init) {
      remarkRef.current.reset();
    }
    setRemarkShow(true);
  };
  const viewAccessory = async ({ settlementNo }) => {
    const data = await docQuery(settlementNo);
    setViewFileData(data);
    setShowViewFile(true);
  };

  const tableRenderBtn = r => (
    <div>
      <p>
        <Popconfirm
          placement="topLeft"
          title={confirmText}
          onConfirm={() => confirmAction(r)}
          okText="确认"
          cancelText="取消"
          disabled={r.settlementStatus !== 2}
        >
          <Button type="primary" className="mr10" disabled={r.settlementStatus !== 2}>
            确认
          </Button>
        </Popconfirm>
        <Button
          type="primary"
          onClick={() => clearRefuseContent(r)}
          className="mr10"
          disabled={r.settlementStatus !== 2}
        >
          拒绝
        </Button>
        <Button type="primary" onClick={() => uploadInvoice(r)} disabled={r.settlementStatus !== 6}>
          上传发票
        </Button>
      </p>
      <Button type="primary" onClick={() => downDetail(r)} className="mr20">
        下载明细
      </Button>
      <Button
        type="primary"
        onClick={() => viewAccessory(r)}
        disabled={!(r.settleStatus === 6 && r.isUploadDoc)}
      >
        查看附件
      </Button>
    </div>
  );
  const columns = [
    {
      title: '排序',
      dataIndex: 'index',
      valueType: 'index',
      width: 100,
    },
    {
      title: '结算订单号',
      dataIndex: 'settlementNo',
      width: 200,
    },
    {
      title: '结算周期',
      dataIndex: 'settlementTime',
      valueType: 'dateRange',
      hideInTable: true,
      width: 200,
    },
    {
      title: '结算周期',
      dataIndex: 'settlementDate',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '待结算金额',
      dataIndex: 'settlementAmount',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '货款结算状态',
      dataIndex: 'settlementStatus',
      valueEnum: settleStatus,
      width: 200,
    },
    {
      title: '操作状态',
      dataIndex: 'supplierOperateStatus',
      valueEnum: actionStatus,
      width: 200,
    },
    {
      title: '原因',
      dataIndex: 'remarktrgyurew',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '操作',
      valueType: 'option',
      width: 280,
      fixed: 'right',
      render: (_, r) => tableRenderBtn(r),
    },
  ];

  return (
    <PageHeaderWrapper>
      <ProTable
        size="small"
        columns={columns}
        className={style.table}
        request={query}
        search={{ collapsed: false }}
        rowKey="id"
        pagination={{
          defaultCurrent: 1,
        }}
        actionRef={protable}
        scroll={{ x: '100%' }}
      />
      <FileModal
        visible={showViewFile}
        fileData={viewFileData}
        onCancel={() => {
          setShowViewFile(false);
        }}
      />
      <UploadModal
        visible={showViewUpload}
        settlementNo={settlementNoV}
        onCancel={() => {
          setShowViewUpload(false);
          reload();
        }}
      />
      <RemarkModal
        visible={remarkShow}
        submit={remark => {
          confirmAction(rowInfo, true, remark);
        }}
        onCancel={() => setRemarkShow(false)}
        ref={remarkRef}
      />
    </PageHeaderWrapper>
  );
};
