import React from 'react';
import { BetaSchemaForm } from '@ant-design/pro-components';
import { notification } from 'antd';
import { infoColumn } from './staticData.js';
import { layout } from '@/utils/bll';
import { apiDeliveriesEdit } from '../../service';

/**
 * 更新收货人手机组件
 */
const LogisticsPhone = props => {
  const refForm = React.useRef();
  const { record } = props;
  const closeModal = v => {
    refForm?.current?.resetFields?.();
    !v && props.onClose(false);
  };
  const submitForm = async values => {
    const params = values;
    params.id = record.id;
    const res = await apiDeliveriesEdit(params);
    if (res?.success) {
      notification.success({
        message: '提交成功',
      });
      props.onClose(true);
    }
  };

  const getInfo = () =>
    new Promise(resolve => {
      resolve({
        ...record,
      });
    });

  return (
    props.visible && (
      <BetaSchemaForm
        layoutType="ModalForm"
        title="更新收货人手机"
        open={props.visible}
        width="600px"
        modalProps={{
          maskClosable: true,
          destroyOnClose: true,
        }}
        request={getInfo}
        formRef={refForm}
        onOpenChange={closeModal}
        layout="horizontal"
        {...layout}
        onFinish={submitForm}
        columns={infoColumn}
      />
    )
  );
};

export default LogisticsPhone;
