import React from 'react';

export const infoColumn = [
  {
    title: '订单号',
    dataIndex: 'orderNo',
    maxLength: 50,
    fieldProps: {
      disabled: true,
    },
  },
  {
    title: '收货人电话',
    dataIndex: 'receiverPhone',
    fieldProps: {
      maxLength: 11,
    },
    formItemProps: {
      rules: [
        { required: true, message: '请填写收货人电话' },
        {
          pattern: /^1[3456789]\d{9}$/,
          message: '请输入正确的手机号',
        },
      ],
      extra: (
        <div style={{ color: '#1890FF' }}>
          <div>提示：</div>
          <div>
            1、请谨慎修改，此功能仅在发货后，线下联系物流公司变更收货信息时填写，系统用于获取物流轨迹
          </div>
          <div>2、格式为数字，请录入11位手机号</div>
        </div>
      ),
    },
  },
  {
    title: '收货人姓名',
    dataIndex: 'receiverName',
    maxLength: 100,
    fieldProps: {
      disabled: true,
    },
  },
  {
    title: '收货地址',
    dataIndex: 'fullAddress',
    maxLength: 50,
    fieldProps: {
      disabled: true,
    },
  },
];
