import React from 'react';
import commonStyle from '../common.less';
export const WrapperContainer = props => (
  <div className={commonStyle.container}>{props.children}</div>
);

/**
 * title 组件
 * value 可以传入多种类型的值
 * onChange只会回调 number|undefined 类型
 * 当isNaN(Number(value)) 为true的时候，代表选择默认类型
 * 当选择默认类型的时候，onChange会回调undefined
 * @param props
 */

export const Title = props => (
  <div className={commonStyle.title}>
    <h3>{props.title}</h3>
  </div>
);

//  export const IdSelect = (props: IdSelectProps) => {
//   const {value, onChange, defaultOptionName, options, ...resetProps} = props;

//   return <Select {...resetProps} value={options?.length ? toNumber(value): 0} onChange={value => onChange?.(toNumber(value) || undefined)}>
//     {
//       defaultOptionName ? <Select.Option value={0}>{defaultOptionName}</Select.Option> : null
//     }
//     {options?.map(option => <Select.Option key={option.id} value={option.id}>{option.name}</Select.Option>)}
//   </Select>
// }
// const toNumber = (value: unknown) => isNaN(Number(value)) ? 0: Number(value);
