import { ConsoleSqlOutlined, MinusCircleOutlined, PlusOutlined } from '@ant-design/icons';
import { Button, Form, Input, Select, Space, Modal, InputNumber, notification } from 'antd';
import React, { useState, forwardRef, useImperativeHandle, useRef, useEffect, useContext } from 'react';
import { useParams } from 'react-router-dom';
import { formItemLayout, StaticColumns } from '../config';
import EditFormTable from './EditFormTable';
import { createProductData, cleanArray } from '../utils';
import { ServiceContext } from '../context';

import { ColumnTypes } from '../type';

const { Option } = Select;

interface SpecItem {
  specId: number;
  specName: string;
}
interface PropsType {
  editData: any;
  specList: Array<SpecItem>;
}

const validatorSpecValue = (value, list, index, specName) => {
  const checkList = list.filter((item, ind) => {
    if (ind === index) {
      return false;
    }
    return item[specName] === value;
  });
  return checkList.length;
};

const SpecificationTemplate = (props, _) => {
  const {
    form,
    name,
    label,
    specName,
    specList,
    selectName,
    onChange = () => {},
    specDataList,
  } = props;
  const customer = useContext(ServiceContext);

  const handleChange = (val, option) => {
    const optionSpecName = option ? option.specName : null;
    form.setFieldsValue({ [selectName]: optionSpecName });
    // onChange();
  };

  const inputOnblurEvent = () => {
    // onChange();
  }

  const bundlePlusAddSpecEvent = (addCallback: () => void) => {
    console.log(name);
    const specId = form.getFieldValue(name);
    if (!specId) {
      Modal.warning({
        maskClosable: true,
        title: `请先选择${label}！`,
      });
      return;
    }
    addCallback();
    // inputOnblurEvent();
  };

  const bundlePlusRemoveSpecEvent = (removeCallback, fieldName) => {
    removeCallback(fieldName)
    // inputOnblurEvent();
  }

  return (
    <>
      <Form.Item name={name} label={label}>
        <Select
          disabled={customer.isEdit}
          allowClear
          options={specList}
          style={{ width: 200 }}
          fieldNames={{ label: 'specName', value: 'specId' }}
          placeholder={`请选择${label}`}
          showSearch
          filterOption={(input, option) =>
            option.specName.toLowerCase().indexOf(input.toLowerCase()) >= 0
          }
          onChange={handleChange}
        />
      </Form.Item>
      <Form.Item name={selectName} hidden></Form.Item>
      <Form.List name={specName}>
        {(fields, { add, remove }) => (
          <>
            {fields.map((field, index) => (
              <Form.Item key={field.key} noStyle shouldUpdate={(prevValues, curValues) => false}>
                {() => (
                  <Space key={field.key} align="baseline">
                    <Form.Item
                      style={{ marginLeft: 10 }}
                      name={[field.name, specName]}
                      rules={[
                        { required: true, message: '请输入规格名称' },
                        {
                          message: '规格名不能重复！',
                          validator(rule, value, callback) {
                            const checkList = form.getFieldValue(specName);
                            const check = validatorSpecValue(value, checkList, index, specName);
                            return check ? callback('规格名不能重复！') : callback();
                          },
                        },
                      ]}
                    >
                      <Input
                        disabled={specDataList[index] && specDataList[index].id}
                        onBlur={inputOnblurEvent}
                        placeholder="请输入规格名称"
                      />
                    </Form.Item>
                    {!(specDataList[index] && specDataList[index].id) && (
                      <MinusCircleOutlined onClick={() => bundlePlusRemoveSpecEvent(remove, field.name)} />
                    )}
                  </Space>
                )}
              </Form.Item>
            ))}
            {fields.length < 3 && (
              <Form.Item noStyle>
                <Button
                  style={{ marginLeft: 10, marginBottom: 24 }}
                  type="dashed"
                  onClick={() => bundlePlusAddSpecEvent(add)}
                  icon={<PlusOutlined />}
                />
              </Form.Item>
            )}
          </>
        )}
      </Form.List>
    </>
  );
};

const originItems = {
  firstSpecValue: [],
  secondSpecValue: [],
  dataSource: [],
  firstDuplicate: [],
  secondDuplicate: [],
};


// 编辑回显示时只获取用到的数据
const filterItem = skuItem => {
  const { imageList, serviceItem, ...argsItem } = skuItem;
  argsItem.disabled = true;
  return argsItem;
};

const filterSpecData = skuList =>
  skuList.reduce((orgin, skuItem) => {
    const item = filterItem(skuItem);
    const { firstSpecValue, secondSpecValue } = item;
    if (firstSpecValue && !orgin.firstDuplicate.includes(firstSpecValue)) {
      orgin.firstSpecValue.push(item);
      orgin.firstDuplicate.push(firstSpecValue);
    }
    if (secondSpecValue && !orgin.secondDuplicate.includes(secondSpecValue)) {
      orgin.secondSpecValue.push(item);
      orgin.secondDuplicate.push(secondSpecValue);
    }
    return orgin;
  }, originItems);

const CreateBatchFormItems = ({ batchChange, editRef, defaultColumns }) => {
  const customer = useContext(ServiceContext);
  const formItems = defaultColumns
    .filter(item => !item.role || item?.role.includes(customer.productType))
    .map((item, index) => (
      <Form.Item
        noStyle
        key={item.dataIndex}
        name={['batchItem', item.dataIndex]}
        initialValue={null}>
        <InputNumber placeholder={item.title} />
      </Form.Item>
    ));
  console.log(formItems.length);

  // const batchEvent = () => {
  //   const batchItem = form.getFieldValue('batchItem');
  //   console.log(batchItem);

  //   // editRef.current.form.setFieldsValue({

  //   // });
  // }

  return <>
    {formItems.length && <Space style={{ marginBottom: 20 }}>
      {formItems.concat(<Button key="batch" type="primary" onClick={batchChange}>批量设置</Button>)}
    </Space>}
  </>;
};


const FormPriceOrStock = forwardRef((props: PropsType, ref) => {
  const { specList, editData } = props;
  const editRef = useRef(null);
  const customer = useContext(ServiceContext);
  const [form] = Form.useForm();
  const [specInitValue, setSpecInitValue] = useState({
    firstSpec: '',
    firstSpecId: null,
    firstSpecValue: [],
    secondSpec: '',
    secondSpecId: null,
    secondSpecValue: [],
  });

  const [defaultColumns, setDefaultColumns] = useState([]);
  const [tableData, setTableData] = useState([]);

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  const CreateColumnsEvent = specData => {
    const columsData = [];
    if (specData.firstSpec && specData.firstSpecValue.length) {
      columsData.push({
        title: specData.firstSpec,
        dataIndex: 'firstSpecValue',
        role: [],
      });
    }

    if (specData.secondSpec && specData.secondSpecValue.length) {
      columsData.push({
        title: specData.secondSpec,
        dataIndex: 'secondSpecValue',
        role: [],
      });
    }

    if (!columsData.length) {
      return;
    }

    const dynamicColumns: (ColumnTypes[number] & { editable?: boolean; dataIndex: string })[] = [
      ...columsData,
      ...StaticColumns,
    ];
    setDefaultColumns(dynamicColumns);
  }

  const onFinish = async () => {
    try {
      const values = await form.validateFields();
      CreateColumnsEvent(values);

      const cleanValues = {
        firstValues: cleanArray(values.firstSpecValue),
        secondValues: cleanArray(values.secondSpecValue),
        firstSpecId: values.firstSpecId,
        secondSpecId: values.secondSpecId,
      };
      const newData = createProductData(cleanValues);
      setTableData(newData);
    } catch (error) {
      console.log(error);
    }
  };

  const batchChange = () => {
    const batchItem = form.getFieldValue('batchItem')
    const batchItemKey = Object.keys(batchItem);
    const resetObject = tableData.map((item, index) => {
      console.log(item);
      batchItemKey.forEach(key => {
        item[key] = batchItem[key] || null;
        // reset[`tableList[${index}]['${key}']`] = batchItem[key] || null;
      });
      return item;
    });
    setTableData(resetObject);
    console.log(resetObject);
    // editRef.current.form.setFieldsValue(resetObject);
    // form.setFieldsValue(resetObject);
  }


  useImperativeHandle(ref, () => ({
    onCheck,
  }));
  const { id } = useParams<any>();
  useEffect(() => {
    if (customer.isEdit) {
      if (!Object.keys(editData).length) return;
      const { skuList } = editData;
      const [oneItem] = skuList;
      // 根据接口过滤数据
      const { firstSpecValue, secondSpecValue, dataSource } = filterSpecData(skuList);
      const specData = {
        firstSpec: oneItem.firstSpec,
        firstSpecId: oneItem.firstSpecId,
        firstSpecValue,
        secondSpec: oneItem.secondSpec,
        secondSpecId: oneItem.secondSpecId,
        secondSpecValue,
      };
      form.setFieldsValue(specData); // 设置规格数据
      setSpecInitValue(specData); // 缓存规格数据
      onFinish(); // 触发生成表格
    }
  }, [customer.isEdit, editData]);


  return (
    <Form
      form={form}
      name="dynamic_form_nest_item"
      // onFinish={onFinish}
      autoComplete="off"
      initialValues={specInitValue}
    >
      <SpecificationTemplate
        form={form}
        onChange={onFinish}
        label="一级规格"
        name="firstSpecId"
        selectName="firstSpec"
        specName="firstSpecValue"
        specList={specList}
        specDataList={specInitValue.firstSpecValue}
      />
      <SpecificationTemplate
        form={form}
        onChange={onFinish}
        label="二级规格"
        name="secondSpecId"
        selectName="secondSpec"
        specName="secondSpecValue"
        specList={specList}
        specDataList={specInitValue.secondSpecValue}
      />
      <div style={{ display: 'flex', justifyContent: 'center', marginBottom: 20 }}>
        <Button type="primary" onClick={onFinish}>
          生成商品信息
        </Button>
      </div>
      <CreateBatchFormItems batchChange={batchChange} editRef={editRef} defaultColumns={defaultColumns} />
      <EditFormTable ref={editRef} defaultColumns={defaultColumns} setTableData={setTableData} initData={tableData} />
    </Form>
  );
});

export default FormPriceOrStock;
