import { InputNumber, InputRef } from 'antd';
import { Button, Form, Input, Popconfirm, Table } from 'antd';
import type { FormInstance } from 'antd/es/form';
import React, { useContext, useEffect, useRef, useState, forwardRef, useImperativeHandle } from 'react';

const EditableContext = React.createContext<FormInstance<any> | null>(null);

interface DataType {
  rowSpanCount?: number;
  supplyPrice: number;
  commissionRate: number;
  marketPrice: number;
  salePrice: number;
  stock: number;
  productStockWarning: number;
}
interface PropType {
  initData: any[];
  defaultColumns: any[];
  setTableData: (item: DataType[]) => {};
};
interface Item {
  key: string;
  name: string;
  age: string;
  address: string;
}
interface EditableCellProps {
  rowIndex: number;
  title: React.ReactNode;
  editable: boolean;
  children: React.ReactNode;
  dataIndex: keyof Item;
  record: Item;
  handleSave: (record: Item) => void;
}
interface EditableRowProps {
  index: number;
}

type EditableTableProps = Parameters<typeof Table>[0];
type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

const EditableRow: React.FC<EditableRowProps> = ({ index, ...props }) => {
  // console.log('==========> index', props);
  // const [form] = Form.useForm();
  // console.log('==========>props', props)
  return (
    // <Form form={form} component={false}>
    //   <EditableContext.Provider value={form}>
        <tr {...props} />
      // </EditableContext.Provider>
    // </Form>
  );
};


const EditableCell: React.FC<EditableCellProps> = (props) => {
  const {
    rowIndex,
    title,
    editable,
    children,
    dataIndex,
    record,
    handleSave,
    ...restProps
  } = props;
  const form = useContext(EditableContext)!;
  const save = async () => {
    try {
      const tableList = form.getFieldValue('tableList');
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  let childNode = children;
  // if (editable) {
    childNode = <Form.Item
      style={{ margin: 0 }}
      name={['tableList', rowIndex, dataIndex]}
      // initialValue={record[dataIndex]}
      rules={[{ required: true, message: `${title} is required.` }]}>
      {editable ?<InputNumber onBlur={save} /> : children[1]}
    </Form.Item>
  // }
  return <td {...restProps}>{childNode}</td>;
};





const EditFormTable = forwardRef((props: PropType, ref) => {

  const { initData, defaultColumns, setTableData } = props;
  // console.log(initData);
  const [dataSource, setDataSource] = useState<DataType[]>([]);
  const [form] = Form.useForm();

  useEffect(() => {
    console.log('==============>坚听initData', initData);
    

    form.setFieldsValue({
      tableList: initData,
    });
    setDataSource(initData);
  }, [initData])

  const handleAdd = async () => {
    try {
      const { tableList } = await form.validateFields();
      console.log(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  const handleSave = (row: DataType[]) => {
    // console.log('============>row', row);
    // const newData = [...dataSource];
    // const index = newData.findIndex(item => row.key === item.key);
    // const item = newData[index];
    // newData.splice(index, 1, {
    //   ...item,
    //   ...row,
    // });
    setTableData([...row]);
  };


  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
    form,
  }));


  // 根据这里做判断渲染表格
  const columns = defaultColumns.map((col, colIndex) => {
    // if (!col.editable) {
    //   return col;
    // }
    

    return {
      ...col,
      onCell: (record: DataType, rowIndex: number) => {
        let rowSpan = null;
        if (col.dataIndex === 'firstSpecValue') {
          // console.log(record, rowSpan);
          rowSpan = record.rowSpanCount ? record.rowSpanCount : 0;
        }

        return ({
          rowSpan,
          record,
          rowIndex,
          editable: col.editable,
          dataIndex: col.dataIndex,
          title: col.title,
          handleSave,
        });
      }
    };
  });
  
  return (
    <div>
      <Form form={form} scrollToFirstError component={false}>
        <EditableContext.Provider value={form}>
          <Table
            pagination={false}
            size="small"
            components={{
              body: {
                row: EditableRow,
                cell: EditableCell,
              },
            }}
            bordered
            dataSource={dataSource}
            rowKey={(row, rowInd) => rowInd}
            columns={columns as ColumnTypes}
          />
        </EditableContext.Provider>
        <Button onClick={handleAdd} type="primary" style={{ marginBottom: 16 }}>Add a row</Button>
      </Form>
    </div>
  );
});

export default EditFormTable;