import { Modal, Button, Row, Col } from 'antd';
import React, { Component } from 'react';
import styles from '../style.less';

// eslint-disable-next-line react/prefer-stateless-function
class imgModal extends Component {
  state = {
    imgModal: false,
    selectImg: '',
  };

  render() {
    const { visible, data = [] } = this.props;
    const { detailImageList = [], skuSpecImageList = [] } = data;
    return (
      <Modal
        title="图片素材"
        visible={visible}
        footer={null}
        onCancel={this.props.onCancel}
        width="700px"
      >
        <div>
          {skuSpecImageList.map(skuImg => (
            <Row type="flex" justify="start" align="middle">
              <Col span={4}>{`滑动图${skuImg.colorSpecValue || ''}:`}</Col>
              <Col span={20}>
                {skuImg.skuSpecImageList.map(item => (
                  <img
                    onClick={() => {
                      this.setState({ imgModal: true, selectImg: item });
                    }}
                    key={item}
                    width={200}
                    alt=""
                    src={item}
                    style={{ margin: 5 }}
                  ></img>
                ))}
              </Col>
            </Row>
          ))}
          <Row type="flex" justify="start" align="middle">
            <Col span={4}>{detailImageList.length ? '详情图:' : ''}</Col>
            <Col span={20}>
              {detailImageList.map(item => (
                <img
                  onClick={() => {
                    this.setState({ imgModal: true, selectImg: item });
                  }}
                  key={item}
                  width={200}
                  alt=""
                  src={item}
                  style={{ margin: 5 }}
                ></img>
              ))}
            </Col>
          </Row>
        </div>
        <Button type="primary" onClick={this.props.onCancel} className={styles.logBtn}>
          取消
        </Button>
        <Modal
          title="图片详情"
          visible={this.state.imgModal}
          footer={null}
          onCancel={() => this.setState({ imgModal: false })}
          width="800px"
        >
          <img width="700px" src={this.state.selectImg} alt=""></img>
        </Modal>
      </Modal>
    );
  }
}

export default imgModal;
