import request from '@/utils/request';
import config from '@/../config/env.config';

const { goodsApi } = config;

export const merchantUpload = async files => {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};
