/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
import React, { useState, useEffect } from 'react';
import { Modal, Timeline, Tabs } from 'antd';
import style from '../index.less';
import { getLogisticsInfo } from '../service';

const { TabPane } = Tabs;
const LogisticsCom = props => {
  const { modalVisible, onCancel } = props;
  const [result, setResult] = useState({});

  const getInfo = async (companyCode, logisticsNo) => {
    const data = await getLogisticsInfo(companyCode, logisticsNo);
    return data;
  };

  useEffect(() => {
    setResult(props.value);
  });
  const callback = async key => {
    const params = key.split('+');
    if (result[params[1]]?.detailList) {
      return;
    }
    const data = getInfo(params[0], params[1]);
    result[params[1]].detailList = data?.logisticsList?.[0]?.detailList ?? [];
  };
  const render = () => {
    const dom = [];
    // eslint-disable-next-line guard-for-in
    // eslint-disable-next-line no-restricted-syntax
    for (const key in result) {
      const value = result[key];
      dom.push(
        <TabPane
          className={style.tabpane}
          tab={value?.expressCompanyName + value?.deliveryNo}
          key={`${value?.expressCompanyCode} + ${key}`}
          tabBarStyle={{ height: '200px' }}
        >
          {value?.detailList?.length ? (
            <Timeline>
              {value?.detailList?.map((item, index) => (
                <Timeline.Item color={index > 0 ? 'gray' : 'blue'}>
                  <p>{item.desc}</p>
                  <p>{item.logisticsTime}</p>
                </Timeline.Item>
              ))}
            </Timeline>
          ) : (
            '暂无物流信息'
          )}
        </TabPane>,
      );
    }
    return dom;
  };
  return (
    <Modal
      destroyOnClose
      title="物流信息"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      afterClose={() => setResult({})}
      bodyStyle={{ maxHeight: '600px', minHeight: '200px', overflow: 'auto' }}
    >
      <Tabs defaultActiveKey="1" onChange={callback}>
        {render()}
      </Tabs>
    </Modal>
  );
};

export default LogisticsCom;
