import { Upload, Icon, Modal, message, Button } from 'antd';
import React, { useState, useEffect } from 'react';
import config from '../../../../config/env.config';
import styles from '../style.less';
import { qiniuToken } from '@/services/qiniu';

const qiniu = require('@/utils/qiniu.min.js');

const { qiniuHost } = config;

let token = null;

class PicturesWall extends React.Component {
  state = {
    fileList: [],
  };

  async componentDidMount() {
    this.initFileList(this.props.fileList || []);
    if (this.props.status === 1) {
      token = await qiniuToken();
    }
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps?.fileList?.fileList) {
      this.initFileList(nextProps.fileList || []);
    }
  }

  initFileList = fileList => {
    const fileLists =
      fileList.map((item, index) => ({
        url: item.url,
        name: item.name ? item.name : '发票',
        uid: index,
        status: 'done',
      })) || [];
    this.setState({ fileList: fileLists });
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  customRequest = ({ file, onError, onSuccess }) => {
    if (file.name) {
      const lastFile = file.name.split('.');
      const index = lastFile.length - 1;
      const types = ['pdf', 'doc', 'docx', 'zip', 'rar', 'png', 'jpeg'];
      if (!types.includes(lastFile[index])) {
        message.error('文件格式错误！');
        return;
      }
    }
    const vm = this;
    const name = file.name + file.uid;
    const observable = qiniu.upload(file, file.name, token);
    const observer = {
      next() {
        // ...
      },
      error() {
        onError(file);
        // ...
      },
      complete(res) {
        const comFile = file;
        const url = `${qiniuHost}/${res.key}`;
        comFile.url = url;
        const list = vm.state.fileList;
        list.push({
          url: file.url,
          name: file.name,
          uid: list.length,
          status: 'done',
        });
        vm.setState({ fileList: [...list] });
        vm.props.onChange(list);

        onSuccess(comFile);
        // ...
      },
    };
    observable.subscribe(observer); // 上传开始
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  render() {
    const { fileList } = this.state;
    const { status } = this.props;

    const uploadButton = (
      <div className={styles.uploadButton}>
        <Icon type="upload" />
        <span style={{ paddingLeft: '10px' }}>点击上传发票</span>
      </div>
    );
    const { max } = this.props;
    return (
      <div className="clearfix">
        <Upload
          {...this.props}
          customRequest={this.customRequest}
          listType="text"
          fileList={fileList}
          onRemove={status === 1 ? this.clearFileList : ''}
        >
          {max && fileList.length >= max ? null : uploadButton}
        </Upload>
      </div>
    );
  }
}
export default PicturesWall;
