import { Tabs } from 'antd';
import React from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { connect } from 'dva';
import { CANCEL_BILL_MANAGE } from '@/../config/permission.config';
import Pending from './Pending';
import PassAudit from './PassAudit';

const { TabPane } = Tabs;

function CancelBillManage(props) {
  const { permissions } = props;

  const canEditable = permissions[CANCEL_BILL_MANAGE.EDITABLE];
  // const [tabKey, setTabKey] = useState({});
  // const changeTab = () => {
  //   const key = tabKey + 1;
  //   setTabKey(key)
  // }

  console.log('permissions', canEditable);
  return (
    <PageHeaderWrapper>
      <Tabs defaultActiveKey="1">
        <TabPane tab="未审核" key="1">
          <Pending canEditable={canEditable} />
        </TabPane>
        <TabPane tab="已审核" key="2">
          <PassAudit canEditable={canEditable} />
        </TabPane>
      </Tabs>
    </PageHeaderWrapper>
  );
}

export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(CancelBillManage);
