import React from 'react';
import { Form, Space, TimePicker } from 'antd';
import { mealSections } from '../staticData/index';
import MealCheckbox from './MealCheckbox';

const MealSection = props => (
  <Form.List name="mealTimePeriod">
    {fields => (
      <>
        {Object.keys(mealSections).map((field, i) => (
          <Space key={field} align="baseline">
            <Form.Item label="" name={[i, 'mealPeriodType']}>
              <MealCheckbox changeType={props.onChange} meals={props.meals} field={field} />
            </Form.Item>
            <Form.Item
              name={[i, 'time']}
              rules={
                props.meals[field] ? [{ type: 'array', required: true, message: '请选择!' }] : []
              }
            >
              <TimePicker.RangePicker format="HH:mm" minuteStep={30} />
            </Form.Item>
          </Space>
        ))}
      </>
    )}
  </Form.List>
);

export default MealSection;
