import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal, Radio, Form, Space, message, Checkbox, Col, Row } from 'antd';
import styles from '../index.less';
import { shopUpdate } from '../service.js';

const EditRepastModal = props => {
  const { editVisible, repastType, id } = props;
  const handleCancel = () => {
    props.onCancel();
  };
  const handleChange = e => {
    console.log(e.target.value);
  };
  const onOk = () => {
    // if (!shopIds.length) {
    //   notification.error({
    //     message: '请添加微店',
    //   });
    // }
  };
  return (
    <>
      <Modal title="餐饮类型" onOk={onOk} visible={editVisible} onCancel={() => handleCancel()}>
        <Form layout="vertical" autoComplete="off">
          <Form.Item label="取餐点下商户餐品类型">
            <Radio.Group onChange={handleChange}>
              <Space direction="vertical">
                <Radio value={1}>外卖</Radio>
                <Radio value={2}>自助餐</Radio>
              </Space>
            </Radio.Group>
            <p className={styles.tip}>切换餐品类型后，请及时维护商品</p>
          </Form.Item>
          <Form.Item label="是否开启餐品类型">
            <Checkbox.Group>
              <Space direction="vertical">
                {(repastType.length &&
                  repastType.map((index, value) => <Checkbox value="A">到店</Checkbox>)) ||
                  ''}
              </Space>
            </Checkbox.Group>
            <p className={styles.tip}>关闭【到店】餐类时，关联到店企业商品将一并删除</p>
          </Form.Item>
        </Form>
      </Modal>
    </>
  );
};

export default EditRepastModal;
