import React, { useState, useRef, useEffect } from 'react';
import { Button, notification } from 'antd';
import ProTable from '@ant-design/pro-table';
import { searchList, orderDetail } from './service';
import { column } from './data';
import DetailTable from './components/detailTable';
import { dateDiff } from './common';

export default () => {
  const table = useRef();
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const viewDetail = async ({ serviceNo }) => {
    const data = await orderDetail({ serviceNo });
    setDetailInfo(data || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setDetailVisible(false);
  };

  const query = async (params, type) => {
    if (params.orderId) {
      params.orderId = `${params.orderId}`.replace(/\s/g, '');
      if (Number.isNaN(+params.orderId)) {
        notification.warning({
          message: '输入的订单Id只能为数字格式',
        });
        return false;
      }
    }
    if (params.receiverPhone) {
      const reg = /^1[3456789]\d{9}$/;
      if (!reg.test(params.receiverPhone)) {
        notification.warning({
          message: '您输入的手机号有误，请重新输入！',
        });
        return false;
      }
    }
    if (params.orderTime && params.orderTime.length) {
      const startTime = params.orderTime[0];
      const endTime = params.orderTime[1];
      if (dateDiff(startTime, endTime)) {
        notification.warning({
          message: '您输入的订单创建时间超过3个月啦！',
        });
        return false;
      }
    }
    if (params.applyTime && params.applyTime.length) {
      const startTime = params.applyTime[0];
      const endTime = params.applyTime[1];
      if (dateDiff(startTime, endTime)) {
        notification.warning({
          message: '您输入的订单取消提交时间超过3个月啦！',
        });
        return false;
      }
    }
    const tempParams = {
      ...params,
      applyTimeStartAt: params.applyTime?.[0],
      applyTimeEndAt: params.applyTime?.[1],
      orderTimeStartAt: params.orderTime?.[0],
      orderTimeEndAt: params.orderTime?.[1],
      auditStatus: 2,
    };

    return searchList(tempParams, type);
  };
  const columns = [
    ...column,
    {
      title: '操作',
      hideInSearch: true,
      width: 150,
      dataIndex: 'action',
      fixed: 'right',
      render: (_, r) => [
        <Button key="link3" onClick={() => viewDetail(r)} type="primary" className="mr10">
          订单详情
        </Button>,
      ],
    },
  ];
  useEffect(() => {
    query(
      {
        current: 1,
        pageSize: 20,
      },
      2,
    );
  });
  return (
    <div>
      <ProTable
        key="passaudit"
        columns={columns}
        request={params => query(params, 2)}
        rowKey="skuId"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%', y: 400 }}
        toolBarRender={false}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
      />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
    </div>
  );
};
