import { InputNumber, Button, Form, Table } from 'antd';
import React, { useContext, createContext, useEffect, useState, forwardRef, useImperativeHandle } from 'react';
import { ServiceContext } from '../context';

const EditableContext = createContext(null);

const EditableRow= ({ index, ...props }) => {
  // console.log('==========> index', props);
  // const [form] = Form.useForm();
  // console.log('==========>props', props)
  return (
    // <Form form={form} component={false}>
    //   <EditableContext.Provider value={form}>
        <tr {...props} />
      // </EditableContext.Provider>
    // </Form>
  );
};


const EditableCell = (props) => {
  const {
    rowIndex,
    title,
    editable,
    children,
    dataIndex,
    record,
    handleSave,
    ...restProps
  } = props;

  const form = useContext(EditableContext)!;
  const save = async () => {
    try {
      const tableList = form.getFieldValue('tableList');
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  let childNode = children;
    childNode = <Form.Item
      style={{ margin: 0 }}
      name={['tableList', rowIndex, dataIndex]}
      rules={[{ required: true, message: `${title} is required.` }]}>
      {editable ? <InputNumber onBlur={save} /> : children[1]}
    </Form.Item>
  return <td {...restProps}>{childNode}</td>;
};





const EditFormTable = forwardRef((props, ref) => {

  const { initData, defaultColumns, setTableData, mergeTable } = props;
  const customer = useContext(ServiceContext);
  const [dataSource, setDataSource] = useState([]);
  const [form] = Form.useForm();
  useEffect(() => {
    console.log('==============>坚听initData', initData);
    form.setFieldsValue({
      tableList: initData,
    });
    setDataSource(initData);
  }, [initData])

  const handleAdd = async () => {
    try {
      const { tableList } = await form.validateFields();
      console.log(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  const handleSave = (row) => {
    setTableData([...row]);
  };


  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
    form,
  }));


  // 根据这里做判断渲染表格
  const columns = defaultColumns
    .filter(item => {
      // console.log('===============>column', item);
      return !item.role || item.role.includes(customer.productType);
    })
    .map((col, colIndex) => {
    return {
      ...col,
      onCell: (record, rowIndex) => {
        let rowSpan = null;
        if (col.dataIndex === 'firstSpecValue' && mergeTable) {
          rowSpan = record.rowSpanCount || 0;
        }

        return ({
          rowSpan,
          record,
          rowIndex,
          editable: col.editable,
          dataIndex: col.dataIndex,
          title: col.title,
          handleSave,
        });
      }
    };
  });
  
  return (
    <div>
      <Form form={form} scrollToFirstError component={false}>
        <EditableContext.Provider value={form}>
          <Table
            pagination={false}
            size="small"
            components={{
              body: {
                row: EditableRow,
                cell: EditableCell,
              },
            }}
            bordered
            dataSource={dataSource}
            rowKey={(row, rowInd) => rowInd}
            columns={columns}
          />
        </EditableContext.Provider>
        <Button onClick={handleAdd} type="primary" style={{ marginBottom: 16 }}>Add a row</Button>
      </Form>
    </div>
  );
});

export default EditFormTable;